<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoAfectacionIGV.xml */
/* Generado: 2022-04-18 21:15:00 */

/* Busqueda de registros de la tabla MST_TipoAfectacionIGV. */
abstract class BaseMST_TipoAfectacionIGVFN extends MST_TipoAfectacionIGVBN
{
    /* Declaracion de constantes */
    const TipoIgvId = "MST_TipoAfectacionIGV.TipoIgvId";
    const Descripcion = "MST_TipoAfectacionIGV.Descripcion";
    const CodigoSunat = "MST_TipoAfectacionIGV.CodigoSunat";
    const CodigoProv = "MST_TipoAfectacionIGV.CodigoProv";
    const CodigoTributo = "MST_TipoAfectacionIGV.CodigoTributo";
    const Estado = "MST_TipoAfectacionIGV.Estado";
    const FechaRegistro = "MST_TipoAfectacionIGV.FechaRegistro";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TipoAfectacionIGV.TipoIgvId AS TipoIgvId, ";
        $s_SQLQuery .= "MST_TipoAfectacionIGV.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_TipoAfectacionIGV.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "MST_TipoAfectacionIGV.CodigoProv AS CodigoProv, ";
        $s_SQLQuery .= "MST_TipoAfectacionIGV.CodigoTributo AS CodigoTributo, ";
        $s_SQLQuery .= "MST_TipoAfectacionIGV.Estado AS Estado, ";
        $s_SQLQuery .= "MST_TipoAfectacionIGV.FechaRegistro AS FechaRegistro ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TipoAfectacionIGVBN */
    public function setByBN( MST_TipoAfectacionIGVBN $o_MST_TipoAfectacionIGVBN )
    {
        if ( !is_null( $o_MST_TipoAfectacionIGVBN->getTipoIgvId() ) )
        {
            $this->setTipoIgvId( $o_MST_TipoAfectacionIGVBN->getTipoIgvId() );
        }
        if ( !is_null( $o_MST_TipoAfectacionIGVBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoAfectacionIGVBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TipoAfectacionIGVBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_MST_TipoAfectacionIGVBN->getCodigoSunat() );
        }
        if ( !is_null( $o_MST_TipoAfectacionIGVBN->getCodigoProv() ) )
        {
            $this->setCodigoProv( $o_MST_TipoAfectacionIGVBN->getCodigoProv() );
        }
        if ( !is_null( $o_MST_TipoAfectacionIGVBN->getCodigoTributo() ) )
        {
            $this->setCodigoTributo( $o_MST_TipoAfectacionIGVBN->getCodigoTributo() );
        }
        if ( !is_null( $o_MST_TipoAfectacionIGVBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TipoAfectacionIGVBN->getEstado() );
        }
        if ( !is_null( $o_MST_TipoAfectacionIGVBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_MST_TipoAfectacionIGVBN->getFechaRegistro() );
        }
    }

    /**
    * @return MST_TipoAfectacionIGVBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_TipoIgvId )
    {
        if( is_null( $i_TipoIgvId ) ){ $i_TipoIgvId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoAfectacionIGV ";
        $s_SQLQuery .= "WHERE TipoIgvId = ".$i_TipoIgvId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_TipoAfectacionIGVBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TipoAfectacionIGVBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TipoAfectacionIGVBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getTipoIgvId() ) ) $s_SQLQuery .= "MST_TipoAfectacionIGV.TipoIgvId = ".$this->getTipoIgvId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_TipoAfectacionIGV.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "MST_TipoAfectacionIGV.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getCodigoProv() ) ) $s_SQLQuery .= "MST_TipoAfectacionIGV.CodigoProv = '".$this->getCodigoProv()."' AND ";
        if ( !is_null( $this->getCodigoTributo() ) ) $s_SQLQuery .= "MST_TipoAfectacionIGV.CodigoTributo = '".$this->getCodigoTributo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_TipoAfectacionIGV.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "MST_TipoAfectacionIGV.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TipoAfectacionIGV WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TipoAfectacionIGVBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoAfectacionIGV WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_TipoAfectacionIGVBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TipoAfectacionIGVBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TipoAfectacionIGVBN[] = $o_MST_TipoAfectacionIGVBN;
            }
        }
        return $a_MST_TipoAfectacionIGVBN;
    }

    /* Devuelve un objeto MST_TipoAfectacionIGVBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TipoAfectacionIGV )
    {
        $o_MST_TipoAfectacionIGVBN = new MST_TipoAfectacionIGVBN();
        if ( !is_null( $a_MST_TipoAfectacionIGV['TipoIgvId'] ) ) $o_MST_TipoAfectacionIGVBN->setTipoIgvId( ( integer ) $a_MST_TipoAfectacionIGV['TipoIgvId'] );
        if ( !is_null( $a_MST_TipoAfectacionIGV['Descripcion'] ) ) $o_MST_TipoAfectacionIGVBN->setDescripcion( $a_MST_TipoAfectacionIGV['Descripcion'] );
        if ( !is_null( $a_MST_TipoAfectacionIGV['CodigoSunat'] ) ) $o_MST_TipoAfectacionIGVBN->setCodigoSunat( $a_MST_TipoAfectacionIGV['CodigoSunat'] );
        if ( !is_null( $a_MST_TipoAfectacionIGV['CodigoProv'] ) ) $o_MST_TipoAfectacionIGVBN->setCodigoProv( $a_MST_TipoAfectacionIGV['CodigoProv'] );
        if ( !is_null( $a_MST_TipoAfectacionIGV['CodigoTributo'] ) ) $o_MST_TipoAfectacionIGVBN->setCodigoTributo( $a_MST_TipoAfectacionIGV['CodigoTributo'] );
        if ( !is_null( $a_MST_TipoAfectacionIGV['Estado'] ) ) $o_MST_TipoAfectacionIGVBN->setEstado( $a_MST_TipoAfectacionIGV['Estado'] );
        if ( !is_null( $a_MST_TipoAfectacionIGV['FechaRegistro'] ) ) $o_MST_TipoAfectacionIGVBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_MST_TipoAfectacionIGV['FechaRegistro'], "Y-m-d H:i:s" ) );
        return $o_MST_TipoAfectacionIGVBN;
    }
}
?>