<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Talla.xml */
/* Generado: 2024-07-07 07:30:04 */

/* Busqueda de registros de la tabla MST_Talla. */
abstract class BaseMST_TallaFN extends MST_TallaBN
{
    /* Declaracion de constantes */
    const IdTalla = "MST_Talla.IdTalla";
    const Descripcion = "MST_Talla.Descripcion";
    const Estado = "MST_Talla.Estado";
    const UsuarioCreacion = "MST_Talla.UsuarioCreacion";
    const FechaCreacion = "MST_Talla.FechaCreacion";
    const UsuarioModificacion = "MST_Talla.UsuarioModificacion";
    const FechaModificacion = "MST_Talla.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Talla.IdTalla AS IdTalla, ";
        $s_SQLQuery .= "MST_Talla.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Talla.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Talla.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Talla.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Talla.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_Talla.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TallaBN */
    public function setByBN( MST_TallaBN $o_MST_TallaBN )
    {
        if ( !is_null( $o_MST_TallaBN->getIdTalla() ) )
        {
            $this->setIdTalla( $o_MST_TallaBN->getIdTalla() );
        }
        if ( !is_null( $o_MST_TallaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TallaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TallaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TallaBN->getEstado() );
        }
        if ( !is_null( $o_MST_TallaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TallaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TallaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TallaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TallaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TallaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_TallaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TallaBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_TallaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTalla )
    {
        if( is_null( $i_IdTalla ) ){ $i_IdTalla = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Talla ";
        $s_SQLQuery .= "WHERE IdTalla = ".$i_IdTalla." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_TallaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TallaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TallaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTalla() ) ) $s_SQLQuery .= "MST_Talla.IdTalla = ".$this->getIdTalla()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Talla.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Talla.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Talla.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Talla.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Talla.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Talla.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Talla WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TallaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Talla WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_TallaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TallaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TallaBN[] = $o_MST_TallaBN;
            }
        }
        return $a_MST_TallaBN;
    }

    /* Devuelve un objeto MST_TallaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Talla )
    {
        $o_MST_TallaBN = new MST_TallaBN();
        if ( !is_null( $a_MST_Talla['IdTalla'] ) ) $o_MST_TallaBN->setIdTalla( ( integer ) $a_MST_Talla['IdTalla'] );
        if ( !is_null( $a_MST_Talla['Descripcion'] ) ) $o_MST_TallaBN->setDescripcion( $a_MST_Talla['Descripcion'] );
        if ( !is_null( $a_MST_Talla['Estado'] ) ) $o_MST_TallaBN->setEstado( $a_MST_Talla['Estado'] );
        if ( !is_null( $a_MST_Talla['UsuarioCreacion'] ) ) $o_MST_TallaBN->setUsuarioCreacion( $a_MST_Talla['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Talla['FechaCreacion'] ) ) $o_MST_TallaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Talla['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Talla['UsuarioModificacion'] ) ) $o_MST_TallaBN->setUsuarioModificacion( $a_MST_Talla['UsuarioModificacion'] );
        if ( !is_null( $a_MST_Talla['FechaModificacion'] ) ) $o_MST_TallaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Talla['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_TallaBN;
    }
}
?>