<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_RelacionReferenciaProducto.xml */
/* Generado: 2024-08-07 06:49:08 */

/* Busqueda de registros de la tabla MST_RelacionReferenciaProducto. */
abstract class BaseMST_RelacionReferenciaProductoFN extends MST_RelacionReferenciaProductoBN
{
    /* Declaracion de constantes */
    const IdReleacion = "MST_RelacionReferenciaProducto.IdReleacion";
    const IdReferencia = "MST_RelacionReferenciaProducto.IdReferencia";
    const IdProveedor = "MST_RelacionReferenciaProducto.IdProveedor";
    const IdColor = "MST_RelacionReferenciaProducto.IdColor";
    const IdCatTalla = "MST_RelacionReferenciaProducto.IdCatTalla";
    const IdTalla = "MST_RelacionReferenciaProducto.IdTalla";
    const IdItem = "MST_RelacionReferenciaProducto.IdItem";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_RelacionReferenciaProducto.IdReleacion AS IdReleacion, ";
        $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdReferencia AS IdReferencia, ";
        $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdProveedor AS IdProveedor, ";
        $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdColor AS IdColor, ";
        $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdCatTalla AS IdCatTalla, ";
        $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdTalla AS IdTalla, ";
        $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdItem AS IdItem ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_RelacionReferenciaProductoBN */
    public function setByBN( MST_RelacionReferenciaProductoBN $o_MST_RelacionReferenciaProductoBN )
    {
        if ( !is_null( $o_MST_RelacionReferenciaProductoBN->getIdReleacion() ) )
        {
            $this->setIdReleacion( $o_MST_RelacionReferenciaProductoBN->getIdReleacion() );
        }
        if ( !is_null( $o_MST_RelacionReferenciaProductoBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_RelacionReferenciaProductoBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_RelacionReferenciaProductoBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_RelacionReferenciaProductoBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_RelacionReferenciaProductoBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_RelacionReferenciaProductoBN->getIdColor() );
        }
        if ( !is_null( $o_MST_RelacionReferenciaProductoBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_RelacionReferenciaProductoBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_RelacionReferenciaProductoBN->getIdTalla() ) )
        {
            $this->setIdTalla( $o_MST_RelacionReferenciaProductoBN->getIdTalla() );
        }
        if ( !is_null( $o_MST_RelacionReferenciaProductoBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_RelacionReferenciaProductoBN->getIdItem() );
        }
    }

    /**
    * @return MST_RelacionReferenciaProductoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdReleacion )
    {
        if( is_null( $i_IdReleacion ) ){ $i_IdReleacion = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_RelacionReferenciaProducto ";
        $s_SQLQuery .= "WHERE IdReleacion = ".$i_IdReleacion." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_RelacionReferenciaProductoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_RelacionReferenciaProductoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_RelacionReferenciaProductoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdReleacion() ) ) $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdReleacion = ".$this->getIdReleacion()." AND ";
        if ( !is_null( $this->getIdReferencia() ) ) $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdReferencia = ".$this->getIdReferencia()." AND ";
        if ( !is_null( $this->getIdProveedor() ) ) $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdProveedor = ".$this->getIdProveedor()." AND ";
        if ( !is_null( $this->getIdColor() ) ) $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdColor = ".$this->getIdColor()." AND ";
        if ( !is_null( $this->getIdCatTalla() ) ) $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdCatTalla = ".$this->getIdCatTalla()." AND ";
        if ( !is_null( $this->getIdTalla() ) ) $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdTalla = ".$this->getIdTalla()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_RelacionReferenciaProducto.IdItem = '".$this->getIdItem()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_RelacionReferenciaProducto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_RelacionReferenciaProductoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_RelacionReferenciaProducto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_RelacionReferenciaProductoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_RelacionReferenciaProductoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_RelacionReferenciaProductoBN[] = $o_MST_RelacionReferenciaProductoBN;
            }
        }
        return $a_MST_RelacionReferenciaProductoBN;
    }

    /* Devuelve un objeto MST_RelacionReferenciaProductoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_RelacionReferenciaProducto )
    {
        $o_MST_RelacionReferenciaProductoBN = new MST_RelacionReferenciaProductoBN();
        if ( !is_null( $a_MST_RelacionReferenciaProducto['IdReleacion'] ) ) $o_MST_RelacionReferenciaProductoBN->setIdReleacion( ( integer ) $a_MST_RelacionReferenciaProducto['IdReleacion'] );
        if ( !is_null( $a_MST_RelacionReferenciaProducto['IdReferencia'] ) ) $o_MST_RelacionReferenciaProductoBN->setIdReferencia( ( integer ) $a_MST_RelacionReferenciaProducto['IdReferencia'] );
        if ( !is_null( $a_MST_RelacionReferenciaProducto['IdProveedor'] ) ) $o_MST_RelacionReferenciaProductoBN->setIdProveedor( ( integer ) $a_MST_RelacionReferenciaProducto['IdProveedor'] );
        if ( !is_null( $a_MST_RelacionReferenciaProducto['IdColor'] ) ) $o_MST_RelacionReferenciaProductoBN->setIdColor( ( integer ) $a_MST_RelacionReferenciaProducto['IdColor'] );
        if ( !is_null( $a_MST_RelacionReferenciaProducto['IdCatTalla'] ) ) $o_MST_RelacionReferenciaProductoBN->setIdCatTalla( ( integer ) $a_MST_RelacionReferenciaProducto['IdCatTalla'] );
        if ( !is_null( $a_MST_RelacionReferenciaProducto['IdTalla'] ) ) $o_MST_RelacionReferenciaProductoBN->setIdTalla( ( integer ) $a_MST_RelacionReferenciaProducto['IdTalla'] );
        if ( !is_null( $a_MST_RelacionReferenciaProducto['IdItem'] ) ) $o_MST_RelacionReferenciaProductoBN->setIdItem( $a_MST_RelacionReferenciaProducto['IdItem'] );
        return $o_MST_RelacionReferenciaProductoBN;
    }
}
?>