<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProductoRelacion.xml */
/* Generado: 2024-07-14 05:40:11 */

/* Busqueda de registros de la tabla MST_ReferenciaProductoRelacion. */
abstract class BaseMST_ReferenciaProductoRelacionFN extends MST_ReferenciaProductoRelacionBN
{
    /* Declaracion de constantes */
    const IdReferencia = "MST_ReferenciaProductoRelacion.IdReferencia";
    const IdItem = "MST_ReferenciaProductoRelacion.IdItem";
    const IdProveedor = "MST_ReferenciaProductoRelacion.IdProveedor";
    const IdColor = "MST_ReferenciaProductoRelacion.IdColor";
    const IdCatTalla = "MST_ReferenciaProductoRelacion.IdCatTalla";
    const CantTrx = "MST_ReferenciaProductoRelacion.CantTrx";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ReferenciaProductoRelacion.IdReferencia AS IdReferencia, ";
        $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdProveedor AS IdProveedor, ";
        $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdColor AS IdColor, ";
        $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdCatTalla AS IdCatTalla, ";
        $s_SQLQuery .= "MST_ReferenciaProductoRelacion.CantTrx AS CantTrx ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ReferenciaProductoRelacionBN */
    public function setByBN( MST_ReferenciaProductoRelacionBN $o_MST_ReferenciaProductoRelacionBN )
    {
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_ReferenciaProductoRelacionBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ReferenciaProductoRelacionBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_ReferenciaProductoRelacionBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_ReferenciaProductoRelacionBN->getIdColor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_ReferenciaProductoRelacionBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoRelacionBN->getCantTrx() ) )
        {
            $this->setCantTrx( $o_MST_ReferenciaProductoRelacionBN->getCantTrx() );
        }
    }

    /**
    * @return MST_ReferenciaProductoRelacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdReferencia, $s_IdItem )
    {
        if( is_null( $i_IdReferencia ) ){ $i_IdReferencia = -1; } 
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProductoRelacion ";
        $s_SQLQuery .= "WHERE IdReferencia = ".$i_IdReferencia." ";
        $s_SQLQuery .= "AND IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ReferenciaProductoRelacionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ReferenciaProductoRelacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ReferenciaProductoRelacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdReferencia() ) ) $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdReferencia = ".$this->getIdReferencia()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdProveedor() ) ) $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdProveedor = ".$this->getIdProveedor()." AND ";
        if ( !is_null( $this->getIdColor() ) ) $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdColor = ".$this->getIdColor()." AND ";
        if ( !is_null( $this->getIdCatTalla() ) ) $s_SQLQuery .= "MST_ReferenciaProductoRelacion.IdCatTalla = ".$this->getIdCatTalla()." AND ";
        if ( !is_null( $this->getCantTrx() ) ) $s_SQLQuery .= "MST_ReferenciaProductoRelacion.CantTrx = ".$this->getCantTrx()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ReferenciaProductoRelacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ReferenciaProductoRelacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProductoRelacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ReferenciaProductoRelacionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ReferenciaProductoRelacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ReferenciaProductoRelacionBN[] = $o_MST_ReferenciaProductoRelacionBN;
            }
        }
        return $a_MST_ReferenciaProductoRelacionBN;
    }

    /* Devuelve un objeto MST_ReferenciaProductoRelacionBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ReferenciaProductoRelacion )
    {
        $o_MST_ReferenciaProductoRelacionBN = new MST_ReferenciaProductoRelacionBN();
        if ( !is_null( $a_MST_ReferenciaProductoRelacion['IdReferencia'] ) ) $o_MST_ReferenciaProductoRelacionBN->setIdReferencia( ( integer ) $a_MST_ReferenciaProductoRelacion['IdReferencia'] );
        if ( !is_null( $a_MST_ReferenciaProductoRelacion['IdItem'] ) ) $o_MST_ReferenciaProductoRelacionBN->setIdItem( $a_MST_ReferenciaProductoRelacion['IdItem'] );
        if ( !is_null( $a_MST_ReferenciaProductoRelacion['IdProveedor'] ) ) $o_MST_ReferenciaProductoRelacionBN->setIdProveedor( ( integer ) $a_MST_ReferenciaProductoRelacion['IdProveedor'] );
        if ( !is_null( $a_MST_ReferenciaProductoRelacion['IdColor'] ) ) $o_MST_ReferenciaProductoRelacionBN->setIdColor( ( integer ) $a_MST_ReferenciaProductoRelacion['IdColor'] );
        if ( !is_null( $a_MST_ReferenciaProductoRelacion['IdCatTalla'] ) ) $o_MST_ReferenciaProductoRelacionBN->setIdCatTalla( ( integer ) $a_MST_ReferenciaProductoRelacion['IdCatTalla'] );
        if ( !is_null( $a_MST_ReferenciaProductoRelacion['CantTrx'] ) ) $o_MST_ReferenciaProductoRelacionBN->setCantTrx( ( integer ) $a_MST_ReferenciaProductoRelacion['CantTrx'] );
        return $o_MST_ReferenciaProductoRelacionBN;
    }
}
?>