<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProducto.xml */
/* Generado: 2024-08-07 03:13:10 */

/* Busqueda de registros de la tabla MST_ReferenciaProducto. */
abstract class BaseMST_ReferenciaProductoFN extends MST_ReferenciaProductoBN
{
    /* Declaracion de constantes */
    const IdReferencia = "MST_ReferenciaProducto.IdReferencia";
    const IdProveedor = "MST_ReferenciaProducto.IdProveedor";
    const Descripcion = "MST_ReferenciaProducto.Descripcion";
    const Estado = "MST_ReferenciaProducto.Estado";
    const CantTrx = "MST_ReferenciaProducto.CantTrx";
    const UsuarioCreacion = "MST_ReferenciaProducto.UsuarioCreacion";
    const FechaCreacion = "MST_ReferenciaProducto.FechaCreacion";
    const UsuarioModificacion = "MST_ReferenciaProducto.UsuarioModificacion";
    const FechaModificacion = "MST_ReferenciaProducto.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ReferenciaProducto.IdReferencia AS IdReferencia, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.IdProveedor AS IdProveedor, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.CantTrx AS CantTrx, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_ReferenciaProducto.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ReferenciaProductoBN */
    public function setByBN( MST_ReferenciaProductoBN $o_MST_ReferenciaProductoBN )
    {
        if ( !is_null( $o_MST_ReferenciaProductoBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_ReferenciaProductoBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_ReferenciaProductoBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ReferenciaProductoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ReferenciaProductoBN->getEstado() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getCantTrx() ) )
        {
            $this->setCantTrx( $o_MST_ReferenciaProductoBN->getCantTrx() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ReferenciaProductoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ReferenciaProductoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ReferenciaProductoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ReferenciaProductoBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_ReferenciaProductoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdReferencia )
    {
        if( is_null( $i_IdReferencia ) ){ $i_IdReferencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProducto ";
        $s_SQLQuery .= "WHERE IdReferencia = ".$i_IdReferencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ReferenciaProductoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ReferenciaProductoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ReferenciaProductoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdReferencia() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.IdReferencia = ".$this->getIdReferencia()." AND ";
        if ( !is_null( $this->getIdProveedor() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.IdProveedor = ".$this->getIdProveedor()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getCantTrx() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.CantTrx = ".$this->getCantTrx()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ReferenciaProducto.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ReferenciaProducto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ReferenciaProductoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProducto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ReferenciaProductoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ReferenciaProductoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ReferenciaProductoBN[] = $o_MST_ReferenciaProductoBN;
            }
        }
        return $a_MST_ReferenciaProductoBN;
    }

    /* Devuelve un objeto MST_ReferenciaProductoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ReferenciaProducto )
    {
        $o_MST_ReferenciaProductoBN = new MST_ReferenciaProductoBN();
        if ( !is_null( $a_MST_ReferenciaProducto['IdReferencia'] ) ) $o_MST_ReferenciaProductoBN->setIdReferencia( ( integer ) $a_MST_ReferenciaProducto['IdReferencia'] );
        if ( !is_null( $a_MST_ReferenciaProducto['IdProveedor'] ) ) $o_MST_ReferenciaProductoBN->setIdProveedor( ( integer ) $a_MST_ReferenciaProducto['IdProveedor'] );
        if ( !is_null( $a_MST_ReferenciaProducto['Descripcion'] ) ) $o_MST_ReferenciaProductoBN->setDescripcion( $a_MST_ReferenciaProducto['Descripcion'] );
        if ( !is_null( $a_MST_ReferenciaProducto['Estado'] ) ) $o_MST_ReferenciaProductoBN->setEstado( $a_MST_ReferenciaProducto['Estado'] );
        if ( !is_null( $a_MST_ReferenciaProducto['CantTrx'] ) ) $o_MST_ReferenciaProductoBN->setCantTrx( ( integer ) $a_MST_ReferenciaProducto['CantTrx'] );
        if ( !is_null( $a_MST_ReferenciaProducto['UsuarioCreacion'] ) ) $o_MST_ReferenciaProductoBN->setUsuarioCreacion( $a_MST_ReferenciaProducto['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ReferenciaProducto['FechaCreacion'] ) ) $o_MST_ReferenciaProductoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ReferenciaProducto['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ReferenciaProducto['UsuarioModificacion'] ) ) $o_MST_ReferenciaProductoBN->setUsuarioModificacion( $a_MST_ReferenciaProducto['UsuarioModificacion'] );
        if ( !is_null( $a_MST_ReferenciaProducto['FechaModificacion'] ) ) $o_MST_ReferenciaProductoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ReferenciaProducto['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_ReferenciaProductoBN;
    }
}
?>