<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProductoColor.xml */
/* Generado: 2024-08-02 05:22:56 */

/* Busqueda de registros de la tabla MST_ReferenciaProductoColor. */
abstract class BaseMST_ReferenciaProductoColorFN extends MST_ReferenciaProductoColorBN
{
    /* Declaracion de constantes */
    const IdReferencia = "MST_ReferenciaProductoColor.IdReferencia";
    const IdColor = "MST_ReferenciaProductoColor.IdColor";
    const ImagenFlag = "MST_ReferenciaProductoColor.ImagenFlag";
    const ImagenReferenciaNombre = "MST_ReferenciaProductoColor.ImagenReferenciaNombre";
    const ImagenReferenciaFisico = "MST_ReferenciaProductoColor.ImagenReferenciaFisico";
    const ImagenReferenciaWeb = "MST_ReferenciaProductoColor.ImagenReferenciaWeb";
    const FechaCreacion = "MST_ReferenciaProductoColor.FechaCreacion";
    const UsuarioCreacion = "MST_ReferenciaProductoColor.UsuarioCreacion";
    const FechaModificacion = "MST_ReferenciaProductoColor.FechaModificacion";
    const UsuarioModificacion = "MST_ReferenciaProductoColor.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ReferenciaProductoColor.IdReferencia AS IdReferencia, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.IdColor AS IdColor, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenFlag AS ImagenFlag, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenReferenciaNombre AS ImagenReferenciaNombre, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenReferenciaFisico AS ImagenReferenciaFisico, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenReferenciaWeb AS ImagenReferenciaWeb, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_ReferenciaProductoColor.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ReferenciaProductoColorBN */
    public function setByBN( MST_ReferenciaProductoColorBN $o_MST_ReferenciaProductoColorBN )
    {
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_ReferenciaProductoColorBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_ReferenciaProductoColorBN->getIdColor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getImagenFlag() ) )
        {
            $this->setImagenFlag( $o_MST_ReferenciaProductoColorBN->getImagenFlag() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaNombre() ) )
        {
            $this->setImagenReferenciaNombre( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaNombre() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaFisico() ) )
        {
            $this->setImagenReferenciaFisico( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaFisico() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaWeb() ) )
        {
            $this->setImagenReferenciaWeb( $o_MST_ReferenciaProductoColorBN->getImagenReferenciaWeb() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ReferenciaProductoColorBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ReferenciaProductoColorBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ReferenciaProductoColorBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoColorBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ReferenciaProductoColorBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_ReferenciaProductoColorBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdReferencia, $i_IdColor )
    {
        if( is_null( $i_IdReferencia ) ){ $i_IdReferencia = -1; } 
        if( is_null( $i_IdColor ) ){ $i_IdColor = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProductoColor ";
        $s_SQLQuery .= "WHERE IdReferencia = ".$i_IdReferencia." ";
        $s_SQLQuery .= "AND IdColor = ".$i_IdColor." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ReferenciaProductoColorBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ReferenciaProductoColorBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ReferenciaProductoColorBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdReferencia() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.IdReferencia = ".$this->getIdReferencia()." AND ";
        if ( !is_null( $this->getIdColor() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.IdColor = ".$this->getIdColor()." AND ";
        if ( !is_null( $this->getImagenFlag() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenFlag = ".$this->getImagenFlag()." AND ";
        if ( !is_null( $this->getImagenReferenciaNombre() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenReferenciaNombre = '".$this->getImagenReferenciaNombre()."' AND ";
        if ( !is_null( $this->getImagenReferenciaFisico() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenReferenciaFisico = '".$this->getImagenReferenciaFisico()."' AND ";
        if ( !is_null( $this->getImagenReferenciaWeb() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.ImagenReferenciaWeb = '".$this->getImagenReferenciaWeb()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ReferenciaProductoColor.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ReferenciaProductoColor WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ReferenciaProductoColorBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ReferenciaProductoColor WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ReferenciaProductoColorBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ReferenciaProductoColorBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ReferenciaProductoColorBN[] = $o_MST_ReferenciaProductoColorBN;
            }
        }
        return $a_MST_ReferenciaProductoColorBN;
    }

    /* Devuelve un objeto MST_ReferenciaProductoColorBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ReferenciaProductoColor )
    {
        $o_MST_ReferenciaProductoColorBN = new MST_ReferenciaProductoColorBN();
        if ( !is_null( $a_MST_ReferenciaProductoColor['IdReferencia'] ) ) $o_MST_ReferenciaProductoColorBN->setIdReferencia( ( integer ) $a_MST_ReferenciaProductoColor['IdReferencia'] );
        if ( !is_null( $a_MST_ReferenciaProductoColor['IdColor'] ) ) $o_MST_ReferenciaProductoColorBN->setIdColor( ( integer ) $a_MST_ReferenciaProductoColor['IdColor'] );
        if ( !is_null( $a_MST_ReferenciaProductoColor['ImagenFlag'] ) ) $o_MST_ReferenciaProductoColorBN->setImagenFlag( ( integer ) $a_MST_ReferenciaProductoColor['ImagenFlag'] );
        if ( !is_null( $a_MST_ReferenciaProductoColor['ImagenReferenciaNombre'] ) ) $o_MST_ReferenciaProductoColorBN->setImagenReferenciaNombre( $a_MST_ReferenciaProductoColor['ImagenReferenciaNombre'] );
        if ( !is_null( $a_MST_ReferenciaProductoColor['ImagenReferenciaFisico'] ) ) $o_MST_ReferenciaProductoColorBN->setImagenReferenciaFisico( $a_MST_ReferenciaProductoColor['ImagenReferenciaFisico'] );
        if ( !is_null( $a_MST_ReferenciaProductoColor['ImagenReferenciaWeb'] ) ) $o_MST_ReferenciaProductoColorBN->setImagenReferenciaWeb( $a_MST_ReferenciaProductoColor['ImagenReferenciaWeb'] );
        if ( !is_null( $a_MST_ReferenciaProductoColor['FechaCreacion'] ) ) $o_MST_ReferenciaProductoColorBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ReferenciaProductoColor['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ReferenciaProductoColor['UsuarioCreacion'] ) ) $o_MST_ReferenciaProductoColorBN->setUsuarioCreacion( $a_MST_ReferenciaProductoColor['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ReferenciaProductoColor['FechaModificacion'] ) ) $o_MST_ReferenciaProductoColorBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ReferenciaProductoColor['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ReferenciaProductoColor['UsuarioModificacion'] ) ) $o_MST_ReferenciaProductoColorBN->setUsuarioModificacion( $a_MST_ReferenciaProductoColor['UsuarioModificacion'] );
        return $o_MST_ReferenciaProductoColorBN;
    }
}
?>