<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Rango.xml */
/* Generado: 2022-04-18 21:14:59 */

/* Busqueda de registros de la tabla MST_Rango. */
abstract class BaseMST_RangoFN extends MST_RangoBN
{
    /* Declaracion de constantes */
    const IdRango = "MST_Rango.IdRango";
    const Descripcion = "MST_Rango.Descripcion";
    const FlagAlquiler = "MST_Rango.FlagAlquiler";
    const FlagVenta = "MST_Rango.FlagVenta";
    const FlagEncofrado = "MST_Rango.FlagEncofrado";
    const FlagDescuentoAdelanto = "MST_Rango.FlagDescuentoAdelanto";
    const FlagDescuentoContado = "MST_Rango.FlagDescuentoContado";
    const Estado = "MST_Rango.Estado";
    const FechaCreacion = "MST_Rango.FechaCreacion";
    const UsuarioCreacion = "MST_Rango.UsuarioCreacion";
    const FechaModificacion = "MST_Rango.FechaModificacion";
    const UsuarioModificacion = "MST_Rango.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Rango.IdRango AS IdRango, ";
        $s_SQLQuery .= "MST_Rango.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Rango.FlagAlquiler AS FlagAlquiler, ";
        $s_SQLQuery .= "MST_Rango.FlagVenta AS FlagVenta, ";
        $s_SQLQuery .= "MST_Rango.FlagEncofrado AS FlagEncofrado, ";
        $s_SQLQuery .= "MST_Rango.FlagDescuentoAdelanto AS FlagDescuentoAdelanto, ";
        $s_SQLQuery .= "MST_Rango.FlagDescuentoContado AS FlagDescuentoContado, ";
        $s_SQLQuery .= "MST_Rango.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Rango.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Rango.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Rango.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_Rango.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_RangoBN */
    public function setByBN( MST_RangoBN $o_MST_RangoBN )
    {
        if ( !is_null( $o_MST_RangoBN->getIdRango() ) )
        {
            $this->setIdRango( $o_MST_RangoBN->getIdRango() );
        }
        if ( !is_null( $o_MST_RangoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_RangoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagAlquiler() ) )
        {
            $this->setFlagAlquiler( $o_MST_RangoBN->getFlagAlquiler() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagVenta() ) )
        {
            $this->setFlagVenta( $o_MST_RangoBN->getFlagVenta() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagEncofrado() ) )
        {
            $this->setFlagEncofrado( $o_MST_RangoBN->getFlagEncofrado() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagDescuentoAdelanto() ) )
        {
            $this->setFlagDescuentoAdelanto( $o_MST_RangoBN->getFlagDescuentoAdelanto() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagDescuentoContado() ) )
        {
            $this->setFlagDescuentoContado( $o_MST_RangoBN->getFlagDescuentoContado() );
        }
        if ( !is_null( $o_MST_RangoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_RangoBN->getEstado() );
        }
        if ( !is_null( $o_MST_RangoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_RangoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_RangoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_RangoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_RangoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_RangoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_RangoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_RangoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_RangoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdRango )
    {
        if( is_null( $i_IdRango ) ){ $i_IdRango = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Rango ";
        $s_SQLQuery .= "WHERE IdRango = ".$i_IdRango." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_RangoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_RangoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_RangoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRango() ) ) $s_SQLQuery .= "MST_Rango.IdRango = ".$this->getIdRango()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Rango.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getFlagAlquiler() ) ) $s_SQLQuery .= "MST_Rango.FlagAlquiler = ".$this->getFlagAlquiler()." AND ";
        if ( !is_null( $this->getFlagVenta() ) ) $s_SQLQuery .= "MST_Rango.FlagVenta = ".$this->getFlagVenta()." AND ";
        if ( !is_null( $this->getFlagEncofrado() ) ) $s_SQLQuery .= "MST_Rango.FlagEncofrado = ".$this->getFlagEncofrado()." AND ";
        if ( !is_null( $this->getFlagDescuentoAdelanto() ) ) $s_SQLQuery .= "MST_Rango.FlagDescuentoAdelanto = ".$this->getFlagDescuentoAdelanto()." AND ";
        if ( !is_null( $this->getFlagDescuentoContado() ) ) $s_SQLQuery .= "MST_Rango.FlagDescuentoContado = ".$this->getFlagDescuentoContado()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Rango.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Rango.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Rango.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Rango.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Rango.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Rango WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_RangoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Rango WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_RangoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_RangoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_RangoBN[] = $o_MST_RangoBN;
            }
        }
        return $a_MST_RangoBN;
    }

    /* Devuelve un objeto MST_RangoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Rango )
    {
        $o_MST_RangoBN = new MST_RangoBN();
        if ( !is_null( $a_MST_Rango['IdRango'] ) ) $o_MST_RangoBN->setIdRango( ( integer ) $a_MST_Rango['IdRango'] );
        if ( !is_null( $a_MST_Rango['Descripcion'] ) ) $o_MST_RangoBN->setDescripcion( $a_MST_Rango['Descripcion'] );
        if ( !is_null( $a_MST_Rango['FlagAlquiler'] ) ) $o_MST_RangoBN->setFlagAlquiler( ( integer ) $a_MST_Rango['FlagAlquiler'] );
        if ( !is_null( $a_MST_Rango['FlagVenta'] ) ) $o_MST_RangoBN->setFlagVenta( ( integer ) $a_MST_Rango['FlagVenta'] );
        if ( !is_null( $a_MST_Rango['FlagEncofrado'] ) ) $o_MST_RangoBN->setFlagEncofrado( ( integer ) $a_MST_Rango['FlagEncofrado'] );
        if ( !is_null( $a_MST_Rango['FlagDescuentoAdelanto'] ) ) $o_MST_RangoBN->setFlagDescuentoAdelanto( ( integer ) $a_MST_Rango['FlagDescuentoAdelanto'] );
        if ( !is_null( $a_MST_Rango['FlagDescuentoContado'] ) ) $o_MST_RangoBN->setFlagDescuentoContado( ( integer ) $a_MST_Rango['FlagDescuentoContado'] );
        if ( !is_null( $a_MST_Rango['Estado'] ) ) $o_MST_RangoBN->setEstado( $a_MST_Rango['Estado'] );
        if ( !is_null( $a_MST_Rango['FechaCreacion'] ) ) $o_MST_RangoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Rango['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Rango['UsuarioCreacion'] ) ) $o_MST_RangoBN->setUsuarioCreacion( $a_MST_Rango['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Rango['FechaModificacion'] ) ) $o_MST_RangoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Rango['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Rango['UsuarioModificacion'] ) ) $o_MST_RangoBN->setUsuarioModificacion( $a_MST_Rango['UsuarioModificacion'] );
        return $o_MST_RangoBN;
    }
}
?>