<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Mercado.xml */
/* Generado: 2022-04-18 21:14:59 */

/* Busqueda de registros de la tabla MST_Mercado. */
abstract class BaseMST_MercadoFN extends MST_MercadoBN
{
    /* Declaracion de constantes */
    const MercadoId = "MST_Mercado.MercadoId";
    const Descripcion = "MST_Mercado.Descripcion";
    const Codigo = "MST_Mercado.Codigo";
    const Estado = "MST_Mercado.Estado";
    const UsuarioModificacion = "MST_Mercado.UsuarioModificacion";
    const FechaModificacion = "MST_Mercado.FechaModificacion";
    const UsuarioCreacion = "MST_Mercado.UsuarioCreacion";
    const FechaCreacion = "MST_Mercado.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Mercado.MercadoId AS MercadoId, ";
        $s_SQLQuery .= "MST_Mercado.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Mercado.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_Mercado.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Mercado.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_Mercado.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_Mercado.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Mercado.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_MercadoBN */
    public function setByBN( MST_MercadoBN $o_MST_MercadoBN )
    {
        if ( !is_null( $o_MST_MercadoBN->getMercadoId() ) )
        {
            $this->setMercadoId( $o_MST_MercadoBN->getMercadoId() );
        }
        if ( !is_null( $o_MST_MercadoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_MercadoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_MercadoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_MercadoBN->getCodigo() );
        }
        if ( !is_null( $o_MST_MercadoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_MercadoBN->getEstado() );
        }
        if ( !is_null( $o_MST_MercadoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_MercadoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_MercadoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_MercadoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_MercadoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_MercadoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_MercadoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_MercadoBN->getFechaCreacion() );
        }
    }

    /**
    * @return MST_MercadoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MercadoId )
    {
        if( is_null( $i_MercadoId ) ){ $i_MercadoId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Mercado ";
        $s_SQLQuery .= "WHERE MercadoId = ".$i_MercadoId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_MercadoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_MercadoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_MercadoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMercadoId() ) ) $s_SQLQuery .= "MST_Mercado.MercadoId = ".$this->getMercadoId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Mercado.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_Mercado.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Mercado.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Mercado.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Mercado.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Mercado.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Mercado.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Mercado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_MercadoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Mercado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_MercadoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_MercadoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_MercadoBN[] = $o_MST_MercadoBN;
            }
        }
        return $a_MST_MercadoBN;
    }

    /* Devuelve un objeto MST_MercadoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Mercado )
    {
        $o_MST_MercadoBN = new MST_MercadoBN();
        if ( !is_null( $a_MST_Mercado['MercadoId'] ) ) $o_MST_MercadoBN->setMercadoId( ( integer ) $a_MST_Mercado['MercadoId'] );
        if ( !is_null( $a_MST_Mercado['Descripcion'] ) ) $o_MST_MercadoBN->setDescripcion( $a_MST_Mercado['Descripcion'] );
        if ( !is_null( $a_MST_Mercado['Codigo'] ) ) $o_MST_MercadoBN->setCodigo( $a_MST_Mercado['Codigo'] );
        if ( !is_null( $a_MST_Mercado['Estado'] ) ) $o_MST_MercadoBN->setEstado( $a_MST_Mercado['Estado'] );
        if ( !is_null( $a_MST_Mercado['UsuarioModificacion'] ) ) $o_MST_MercadoBN->setUsuarioModificacion( $a_MST_Mercado['UsuarioModificacion'] );
        if ( !is_null( $a_MST_Mercado['FechaModificacion'] ) ) $o_MST_MercadoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Mercado['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Mercado['UsuarioCreacion'] ) ) $o_MST_MercadoBN->setUsuarioCreacion( $a_MST_Mercado['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Mercado['FechaCreacion'] ) ) $o_MST_MercadoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Mercado['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_MST_MercadoBN;
    }
}
?>