<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClaseLinea.xml */
/* Generado: 2022-04-18 21:14:57 */

/* Busqueda de registros de la tabla MST_ClaseLinea. */
abstract class BaseMST_ClaseLineaFN extends MST_ClaseLineaBN
{
    /* Declaracion de constantes */
    const IdLinea = "MST_ClaseLinea.IdLinea";
    const Descripcion = "MST_ClaseLinea.Descripcion";
    const Codigo = "MST_ClaseLinea.Codigo";
    const Estado = "MST_ClaseLinea.Estado";
    const FechaCreacion = "MST_ClaseLinea.FechaCreacion";
    const UsuarioCreacion = "MST_ClaseLinea.UsuarioCreacion";
    const UsuarioModificacion = "MST_ClaseLinea.UsuarioModificacion";
    const FechaModificacion = "MST_ClaseLinea.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ClaseLinea.IdLinea AS IdLinea, ";
        $s_SQLQuery .= "MST_ClaseLinea.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_ClaseLinea.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_ClaseLinea.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ClaseLinea.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ClaseLinea.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ClaseLinea.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_ClaseLinea.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ClaseLineaBN */
    public function setByBN( MST_ClaseLineaBN $o_MST_ClaseLineaBN )
    {
        if ( !is_null( $o_MST_ClaseLineaBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_MST_ClaseLineaBN->getIdLinea() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ClaseLineaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_ClaseLineaBN->getCodigo() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ClaseLineaBN->getEstado() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ClaseLineaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ClaseLineaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ClaseLineaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ClaseLineaBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_ClaseLineaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdLinea )
    {
        if( is_null( $i_IdLinea ) ){ $i_IdLinea = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClaseLinea ";
        $s_SQLQuery .= "WHERE IdLinea = ".$i_IdLinea." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ClaseLineaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ClaseLineaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ClaseLineaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdLinea() ) ) $s_SQLQuery .= "MST_ClaseLinea.IdLinea = ".$this->getIdLinea()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_ClaseLinea.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_ClaseLinea.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ClaseLinea.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ClaseLinea.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ClaseLinea.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ClaseLinea.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ClaseLinea.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ClaseLinea WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ClaseLineaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClaseLinea WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ClaseLineaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ClaseLineaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ClaseLineaBN[] = $o_MST_ClaseLineaBN;
            }
        }
        return $a_MST_ClaseLineaBN;
    }

    /* Devuelve un objeto MST_ClaseLineaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ClaseLinea )
    {
        $o_MST_ClaseLineaBN = new MST_ClaseLineaBN();
        if ( !is_null( $a_MST_ClaseLinea['IdLinea'] ) ) $o_MST_ClaseLineaBN->setIdLinea( ( integer ) $a_MST_ClaseLinea['IdLinea'] );
        if ( !is_null( $a_MST_ClaseLinea['Descripcion'] ) ) $o_MST_ClaseLineaBN->setDescripcion( $a_MST_ClaseLinea['Descripcion'] );
        if ( !is_null( $a_MST_ClaseLinea['Codigo'] ) ) $o_MST_ClaseLineaBN->setCodigo( $a_MST_ClaseLinea['Codigo'] );
        if ( !is_null( $a_MST_ClaseLinea['Estado'] ) ) $o_MST_ClaseLineaBN->setEstado( $a_MST_ClaseLinea['Estado'] );
        if ( !is_null( $a_MST_ClaseLinea['FechaCreacion'] ) ) $o_MST_ClaseLineaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ClaseLinea['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ClaseLinea['UsuarioCreacion'] ) ) $o_MST_ClaseLineaBN->setUsuarioCreacion( $a_MST_ClaseLinea['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ClaseLinea['UsuarioModificacion'] ) ) $o_MST_ClaseLineaBN->setUsuarioModificacion( $a_MST_ClaseLinea['UsuarioModificacion'] );
        if ( !is_null( $a_MST_ClaseLinea['FechaModificacion'] ) ) $o_MST_ClaseLineaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ClaseLinea['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_ClaseLineaBN;
    }
}
?>