<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_SucursalDocumento.xml */
/* Generado: 2022-04-18 21:14:56 */

/* Busqueda de registros de la tabla GSS_SucursalDocumento. */
abstract class BaseGSS_SucursalDocumentoFN extends GSS_SucursalDocumentoBN
{
    /* Declaracion de constantes */
    const IdSucursalDocumento = "GSS_SucursalDocumento.IdSucursalDocumento";
    const IdCompania = "GSS_SucursalDocumento.IdCompania";
    const IdSucursal = "GSS_SucursalDocumento.IdSucursal";
    const IdTipoDocumento = "GSS_SucursalDocumento.IdTipoDocumento";
    const DocumentoTicketFlag = "GSS_SucursalDocumento.DocumentoTicketFlag";
    const AutorizacionSunatTicket = "GSS_SucursalDocumento.AutorizacionSunatTicket";
    const SerieTicket = "GSS_SucursalDocumento.SerieTicket";
    const DocumentoFormatoFlag = "GSS_SucursalDocumento.DocumentoFormatoFlag";
    const EmpresaImprimioFormato = "GSS_SucursalDocumento.EmpresaImprimioFormato";
    const RUCImprimioFormato = "GSS_SucursalDocumento.RUCImprimioFormato";
    const AutorizacionImprimioFormato = "GSS_SucursalDocumento.AutorizacionImprimioFormato";
    const FechaInicioFormato = "GSS_SucursalDocumento.FechaInicioFormato";
    const FechaFinFormato = "GSS_SucursalDocumento.FechaFinFormato";
    const SerieFormato = "GSS_SucursalDocumento.SerieFormato";
    const NumeroActual = "GSS_SucursalDocumento.NumeroActual";
    const RangoDesdeFormato = "GSS_SucursalDocumento.RangoDesdeFormato";
    const RangoHastaFormato = "GSS_SucursalDocumento.RangoHastaFormato";
    const Estado = "GSS_SucursalDocumento.Estado";
    const FechaCreacion = "GSS_SucursalDocumento.FechaCreacion";
    const UsuarioCreacion = "GSS_SucursalDocumento.UsuarioCreacion";
    const FechaModificacion = "GSS_SucursalDocumento.FechaModificacion";
    const UsuarioModificacion = "GSS_SucursalDocumento.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_SucursalDocumento.IdSucursalDocumento AS IdSucursalDocumento, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.DocumentoTicketFlag AS DocumentoTicketFlag, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.AutorizacionSunatTicket AS AutorizacionSunatTicket, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.SerieTicket AS SerieTicket, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.DocumentoFormatoFlag AS DocumentoFormatoFlag, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.EmpresaImprimioFormato AS EmpresaImprimioFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.RUCImprimioFormato AS RUCImprimioFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.AutorizacionImprimioFormato AS AutorizacionImprimioFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.FechaInicioFormato AS FechaInicioFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.FechaFinFormato AS FechaFinFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.SerieFormato AS SerieFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.NumeroActual AS NumeroActual, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.RangoDesdeFormato AS RangoDesdeFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.RangoHastaFormato AS RangoHastaFormato, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_SucursalDocumento.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_SucursalDocumentoBN */
    public function setByBN( GSS_SucursalDocumentoBN $o_GSS_SucursalDocumentoBN )
    {
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getIdSucursalDocumento() ) )
        {
            $this->setIdSucursalDocumento( $o_GSS_SucursalDocumentoBN->getIdSucursalDocumento() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_SucursalDocumentoBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_GSS_SucursalDocumentoBN->getIdSucursal() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getDocumentoTicketFlag() ) )
        {
            $this->setDocumentoTicketFlag( $o_GSS_SucursalDocumentoBN->getDocumentoTicketFlag() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getAutorizacionSunatTicket() ) )
        {
            $this->setAutorizacionSunatTicket( $o_GSS_SucursalDocumentoBN->getAutorizacionSunatTicket() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getSerieTicket() ) )
        {
            $this->setSerieTicket( $o_GSS_SucursalDocumentoBN->getSerieTicket() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getDocumentoFormatoFlag() ) )
        {
            $this->setDocumentoFormatoFlag( $o_GSS_SucursalDocumentoBN->getDocumentoFormatoFlag() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getEmpresaImprimioFormato() ) )
        {
            $this->setEmpresaImprimioFormato( $o_GSS_SucursalDocumentoBN->getEmpresaImprimioFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getRUCImprimioFormato() ) )
        {
            $this->setRUCImprimioFormato( $o_GSS_SucursalDocumentoBN->getRUCImprimioFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getAutorizacionImprimioFormato() ) )
        {
            $this->setAutorizacionImprimioFormato( $o_GSS_SucursalDocumentoBN->getAutorizacionImprimioFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getFechaInicioFormato() ) )
        {
            $this->setFechaInicioFormato( $o_GSS_SucursalDocumentoBN->getFechaInicioFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getFechaFinFormato() ) )
        {
            $this->setFechaFinFormato( $o_GSS_SucursalDocumentoBN->getFechaFinFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getSerieFormato() ) )
        {
            $this->setSerieFormato( $o_GSS_SucursalDocumentoBN->getSerieFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getNumeroActual() ) )
        {
            $this->setNumeroActual( $o_GSS_SucursalDocumentoBN->getNumeroActual() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getRangoDesdeFormato() ) )
        {
            $this->setRangoDesdeFormato( $o_GSS_SucursalDocumentoBN->getRangoDesdeFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getRangoHastaFormato() ) )
        {
            $this->setRangoHastaFormato( $o_GSS_SucursalDocumentoBN->getRangoHastaFormato() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_SucursalDocumentoBN->getEstado() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_SucursalDocumentoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_SucursalDocumentoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_SucursalDocumentoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_SucursalDocumentoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_SucursalDocumentoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_SucursalDocumentoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdSucursalDocumento )
    {
        if( is_null( $i_IdSucursalDocumento ) ){ $i_IdSucursalDocumento = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_SucursalDocumento ";
        $s_SQLQuery .= "WHERE IdSucursalDocumento = ".$i_IdSucursalDocumento." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_GSS_SucursalDocumentoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_SucursalDocumentoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_SucursalDocumentoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdSucursalDocumento() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.IdSucursalDocumento = ".$this->getIdSucursalDocumento()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getDocumentoTicketFlag() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.DocumentoTicketFlag = '".$this->getDocumentoTicketFlag()."' AND ";
        if ( !is_null( $this->getAutorizacionSunatTicket() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.AutorizacionSunatTicket = '".$this->getAutorizacionSunatTicket()."' AND ";
        if ( !is_null( $this->getSerieTicket() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.SerieTicket = '".$this->getSerieTicket()."' AND ";
        if ( !is_null( $this->getDocumentoFormatoFlag() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.DocumentoFormatoFlag = '".$this->getDocumentoFormatoFlag()."' AND ";
        if ( !is_null( $this->getEmpresaImprimioFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.EmpresaImprimioFormato = '".$this->getEmpresaImprimioFormato()."' AND ";
        if ( !is_null( $this->getRUCImprimioFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.RUCImprimioFormato = '".$this->getRUCImprimioFormato()."' AND ";
        if ( !is_null( $this->getAutorizacionImprimioFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.AutorizacionImprimioFormato = '".$this->getAutorizacionImprimioFormato()."' AND ";
        if ( !is_null( $this->getFechaInicioFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.FechaInicioFormato = '".$this->getFechaInicioFormato()."' AND ";
        if ( !is_null( $this->getFechaFinFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.FechaFinFormato = '".$this->getFechaFinFormato()."' AND ";
        if ( !is_null( $this->getSerieFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.SerieFormato = '".$this->getSerieFormato()."' AND ";
        if ( !is_null( $this->getNumeroActual() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.NumeroActual = ".$this->getNumeroActual()." AND ";
        if ( !is_null( $this->getRangoDesdeFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.RangoDesdeFormato = ".$this->getRangoDesdeFormato()." AND ";
        if ( !is_null( $this->getRangoHastaFormato() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.RangoHastaFormato = ".$this->getRangoHastaFormato()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_SucursalDocumento.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_SucursalDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_SucursalDocumentoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_SucursalDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_GSS_SucursalDocumentoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_SucursalDocumentoBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_SucursalDocumentoBN[] = $o_GSS_SucursalDocumentoBN;
            }
        }
        return $a_GSS_SucursalDocumentoBN;
    }

    /* Devuelve un objeto GSS_SucursalDocumentoBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_SucursalDocumento )
    {
        $o_GSS_SucursalDocumentoBN = new GSS_SucursalDocumentoBN();
        if ( !is_null( $a_GSS_SucursalDocumento['IdSucursalDocumento'] ) ) $o_GSS_SucursalDocumentoBN->setIdSucursalDocumento( ( integer ) $a_GSS_SucursalDocumento['IdSucursalDocumento'] );
        if ( !is_null( $a_GSS_SucursalDocumento['IdCompania'] ) ) $o_GSS_SucursalDocumentoBN->setIdCompania( ( integer ) $a_GSS_SucursalDocumento['IdCompania'] );
        if ( !is_null( $a_GSS_SucursalDocumento['IdSucursal'] ) ) $o_GSS_SucursalDocumentoBN->setIdSucursal( ( integer ) $a_GSS_SucursalDocumento['IdSucursal'] );
        if ( !is_null( $a_GSS_SucursalDocumento['IdTipoDocumento'] ) ) $o_GSS_SucursalDocumentoBN->setIdTipoDocumento( $a_GSS_SucursalDocumento['IdTipoDocumento'] );
        if ( !is_null( $a_GSS_SucursalDocumento['DocumentoTicketFlag'] ) ) $o_GSS_SucursalDocumentoBN->setDocumentoTicketFlag( $a_GSS_SucursalDocumento['DocumentoTicketFlag'] );
        if ( !is_null( $a_GSS_SucursalDocumento['AutorizacionSunatTicket'] ) ) $o_GSS_SucursalDocumentoBN->setAutorizacionSunatTicket( $a_GSS_SucursalDocumento['AutorizacionSunatTicket'] );
        if ( !is_null( $a_GSS_SucursalDocumento['SerieTicket'] ) ) $o_GSS_SucursalDocumentoBN->setSerieTicket( $a_GSS_SucursalDocumento['SerieTicket'] );
        if ( !is_null( $a_GSS_SucursalDocumento['DocumentoFormatoFlag'] ) ) $o_GSS_SucursalDocumentoBN->setDocumentoFormatoFlag( $a_GSS_SucursalDocumento['DocumentoFormatoFlag'] );
        if ( !is_null( $a_GSS_SucursalDocumento['EmpresaImprimioFormato'] ) ) $o_GSS_SucursalDocumentoBN->setEmpresaImprimioFormato( $a_GSS_SucursalDocumento['EmpresaImprimioFormato'] );
        if ( !is_null( $a_GSS_SucursalDocumento['RUCImprimioFormato'] ) ) $o_GSS_SucursalDocumentoBN->setRUCImprimioFormato( $a_GSS_SucursalDocumento['RUCImprimioFormato'] );
        if ( !is_null( $a_GSS_SucursalDocumento['AutorizacionImprimioFormato'] ) ) $o_GSS_SucursalDocumentoBN->setAutorizacionImprimioFormato( $a_GSS_SucursalDocumento['AutorizacionImprimioFormato'] );
        if ( !is_null( $a_GSS_SucursalDocumento['FechaInicioFormato'] ) ) $o_GSS_SucursalDocumentoBN->setFechaInicioFormato( utilTimestamp::getTimestamp( $a_GSS_SucursalDocumento['FechaInicioFormato'], "Y-m-d" ) );
        if ( !is_null( $a_GSS_SucursalDocumento['FechaFinFormato'] ) ) $o_GSS_SucursalDocumentoBN->setFechaFinFormato( utilTimestamp::getTimestamp( $a_GSS_SucursalDocumento['FechaFinFormato'], "Y-m-d" ) );
        if ( !is_null( $a_GSS_SucursalDocumento['SerieFormato'] ) ) $o_GSS_SucursalDocumentoBN->setSerieFormato( $a_GSS_SucursalDocumento['SerieFormato'] );
        if ( !is_null( $a_GSS_SucursalDocumento['NumeroActual'] ) ) $o_GSS_SucursalDocumentoBN->setNumeroActual( ( integer ) $a_GSS_SucursalDocumento['NumeroActual'] );
        if ( !is_null( $a_GSS_SucursalDocumento['RangoDesdeFormato'] ) ) $o_GSS_SucursalDocumentoBN->setRangoDesdeFormato( ( integer ) $a_GSS_SucursalDocumento['RangoDesdeFormato'] );
        if ( !is_null( $a_GSS_SucursalDocumento['RangoHastaFormato'] ) ) $o_GSS_SucursalDocumentoBN->setRangoHastaFormato( ( integer ) $a_GSS_SucursalDocumento['RangoHastaFormato'] );
        if ( !is_null( $a_GSS_SucursalDocumento['Estado'] ) ) $o_GSS_SucursalDocumentoBN->setEstado( $a_GSS_SucursalDocumento['Estado'] );
        if ( !is_null( $a_GSS_SucursalDocumento['FechaCreacion'] ) ) $o_GSS_SucursalDocumentoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_SucursalDocumento['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_SucursalDocumento['UsuarioCreacion'] ) ) $o_GSS_SucursalDocumentoBN->setUsuarioCreacion( $a_GSS_SucursalDocumento['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_SucursalDocumento['FechaModificacion'] ) ) $o_GSS_SucursalDocumentoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_SucursalDocumento['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_SucursalDocumento['UsuarioModificacion'] ) ) $o_GSS_SucursalDocumentoBN->setUsuarioModificacion( $a_GSS_SucursalDocumento['UsuarioModificacion'] );
        return $o_GSS_SucursalDocumentoBN;
    }
}
?>