<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_ParametroMast.xml */
/* Generado: 2022-04-18 21:14:56 */

/* Busqueda de registros de la tabla GSS_ParametroMast. */
abstract class BaseGSS_ParametroMastFN extends GSS_ParametroMastBN
{
    /* Declaracion de constantes */
    const IdCompania = "GSS_ParametroMast.IdCompania";
    const IdAplicacionCodigo = "GSS_ParametroMast.IdAplicacionCodigo";
    const IdParametroClave = "GSS_ParametroMast.IdParametroClave";
    const DescripcionParametro = "GSS_ParametroMast.DescripcionParametro";
    const Explicacion = "GSS_ParametroMast.Explicacion";
    const TipodeDatoFlag = "GSS_ParametroMast.TipodeDatoFlag";
    const Texto = "GSS_ParametroMast.Texto";
    const Numero = "GSS_ParametroMast.Numero";
    const Fecha = "GSS_ParametroMast.Fecha";
    const Estado = "GSS_ParametroMast.Estado";
    const UsuarioModificacion = "GSS_ParametroMast.UsuarioModificacion";
    const FechaModificacion = "GSS_ParametroMast.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_ParametroMast.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_ParametroMast.IdAplicacionCodigo AS IdAplicacionCodigo, ";
        $s_SQLQuery .= "GSS_ParametroMast.IdParametroClave AS IdParametroClave, ";
        $s_SQLQuery .= "GSS_ParametroMast.DescripcionParametro AS DescripcionParametro, ";
        $s_SQLQuery .= "GSS_ParametroMast.Explicacion AS Explicacion, ";
        $s_SQLQuery .= "GSS_ParametroMast.TipodeDatoFlag AS TipodeDatoFlag, ";
        $s_SQLQuery .= "GSS_ParametroMast.Texto AS Texto, ";
        $s_SQLQuery .= "GSS_ParametroMast.Numero AS Numero, ";
        $s_SQLQuery .= "GSS_ParametroMast.Fecha AS Fecha, ";
        $s_SQLQuery .= "GSS_ParametroMast.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_ParametroMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "GSS_ParametroMast.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_ParametroMastBN */
    public function setByBN( GSS_ParametroMastBN $o_GSS_ParametroMastBN )
    {
        if ( !is_null( $o_GSS_ParametroMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_ParametroMastBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getIdAplicacionCodigo() ) )
        {
            $this->setIdAplicacionCodigo( $o_GSS_ParametroMastBN->getIdAplicacionCodigo() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getIdParametroClave() ) )
        {
            $this->setIdParametroClave( $o_GSS_ParametroMastBN->getIdParametroClave() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getDescripcionParametro() ) )
        {
            $this->setDescripcionParametro( $o_GSS_ParametroMastBN->getDescripcionParametro() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getExplicacion() ) )
        {
            $this->setExplicacion( $o_GSS_ParametroMastBN->getExplicacion() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getTipodeDatoFlag() ) )
        {
            $this->setTipodeDatoFlag( $o_GSS_ParametroMastBN->getTipodeDatoFlag() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getTexto() ) )
        {
            $this->setTexto( $o_GSS_ParametroMastBN->getTexto() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getNumero() ) )
        {
            $this->setNumero( $o_GSS_ParametroMastBN->getNumero() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getFecha() ) )
        {
            $this->setFecha( $o_GSS_ParametroMastBN->getFecha() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_ParametroMastBN->getEstado() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_ParametroMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_ParametroMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_ParametroMastBN->getFechaModificacion() );
        }
    }

    /**
    * @return GSS_ParametroMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdAplicacionCodigo, $s_IdParametroClave )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdAplicacionCodigo ) ){ $s_IdAplicacionCodigo = '-1'; } 
        if( is_null( $s_IdParametroClave ) ){ $s_IdParametroClave = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_ParametroMast ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdAplicacionCodigo = '".$s_IdAplicacionCodigo."' ";
        $s_SQLQuery .= "AND IdParametroClave = '".$s_IdParametroClave."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_GSS_ParametroMastBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_ParametroMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_ParametroMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_ParametroMast.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdAplicacionCodigo() ) ) $s_SQLQuery .= "GSS_ParametroMast.IdAplicacionCodigo = '".$this->getIdAplicacionCodigo()."' AND ";
        if ( !is_null( $this->getIdParametroClave() ) ) $s_SQLQuery .= "GSS_ParametroMast.IdParametroClave = '".$this->getIdParametroClave()."' AND ";
        if ( !is_null( $this->getDescripcionParametro() ) ) $s_SQLQuery .= "GSS_ParametroMast.DescripcionParametro = '".$this->getDescripcionParametro()."' AND ";
        if ( !is_null( $this->getExplicacion() ) ) $s_SQLQuery .= "GSS_ParametroMast.Explicacion = '".$this->getExplicacion()."' AND ";
        if ( !is_null( $this->getTipodeDatoFlag() ) ) $s_SQLQuery .= "GSS_ParametroMast.TipodeDatoFlag = '".$this->getTipodeDatoFlag()."' AND ";
        if ( !is_null( $this->getTexto() ) ) $s_SQLQuery .= "GSS_ParametroMast.Texto = '".$this->getTexto()."' AND ";
        if ( !is_null( $this->getNumero() ) ) $s_SQLQuery .= "GSS_ParametroMast.Numero = ".$this->getNumero()." AND ";
        if ( !is_null( $this->getFecha() ) ) $s_SQLQuery .= "GSS_ParametroMast.Fecha = '".$this->getFecha()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_ParametroMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_ParametroMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_ParametroMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_ParametroMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_ParametroMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_ParametroMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_GSS_ParametroMastBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_ParametroMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_ParametroMastBN[] = $o_GSS_ParametroMastBN;
            }
        }
        return $a_GSS_ParametroMastBN;
    }

    /* Devuelve un objeto GSS_ParametroMastBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_ParametroMast )
    {
        $o_GSS_ParametroMastBN = new GSS_ParametroMastBN();
        if ( !is_null( $a_GSS_ParametroMast['IdCompania'] ) ) $o_GSS_ParametroMastBN->setIdCompania( ( integer ) $a_GSS_ParametroMast['IdCompania'] );
        if ( !is_null( $a_GSS_ParametroMast['IdAplicacionCodigo'] ) ) $o_GSS_ParametroMastBN->setIdAplicacionCodigo( $a_GSS_ParametroMast['IdAplicacionCodigo'] );
        if ( !is_null( $a_GSS_ParametroMast['IdParametroClave'] ) ) $o_GSS_ParametroMastBN->setIdParametroClave( $a_GSS_ParametroMast['IdParametroClave'] );
        if ( !is_null( $a_GSS_ParametroMast['DescripcionParametro'] ) ) $o_GSS_ParametroMastBN->setDescripcionParametro( $a_GSS_ParametroMast['DescripcionParametro'] );
        if ( !is_null( $a_GSS_ParametroMast['Explicacion'] ) ) $o_GSS_ParametroMastBN->setExplicacion( $a_GSS_ParametroMast['Explicacion'] );
        if ( !is_null( $a_GSS_ParametroMast['TipodeDatoFlag'] ) ) $o_GSS_ParametroMastBN->setTipodeDatoFlag( $a_GSS_ParametroMast['TipodeDatoFlag'] );
        if ( !is_null( $a_GSS_ParametroMast['Texto'] ) ) $o_GSS_ParametroMastBN->setTexto( $a_GSS_ParametroMast['Texto'] );
        if ( !is_null( $a_GSS_ParametroMast['Numero'] ) ) $o_GSS_ParametroMastBN->setNumero( ( float ) $a_GSS_ParametroMast['Numero'] );
        if ( !is_null( $a_GSS_ParametroMast['Fecha'] ) ) $o_GSS_ParametroMastBN->setFecha( utilTimestamp::getTimestamp( $a_GSS_ParametroMast['Fecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_ParametroMast['Estado'] ) ) $o_GSS_ParametroMastBN->setEstado( $a_GSS_ParametroMast['Estado'] );
        if ( !is_null( $a_GSS_ParametroMast['UsuarioModificacion'] ) ) $o_GSS_ParametroMastBN->setUsuarioModificacion( $a_GSS_ParametroMast['UsuarioModificacion'] );
        if ( !is_null( $a_GSS_ParametroMast['FechaModificacion'] ) ) $o_GSS_ParametroMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_ParametroMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_GSS_ParametroMastBN;
    }
}
?>