<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_CentroCostos.xml */
/* Generado: 2022-04-18 21:14:55 */

/* Busqueda de registros de la tabla GSS_CentroCostos. */
abstract class BaseGSS_CentroCostosFN extends GSS_CentroCostosBN
{
    /* Declaracion de constantes */
    const IdCeCostos = "GSS_CentroCostos.IdCeCostos";
    const Descripcion = "GSS_CentroCostos.Descripcion";
    const Codigo = "GSS_CentroCostos.Codigo";
    const Estado = "GSS_CentroCostos.Estado";
    const FechaCreacion = "GSS_CentroCostos.FechaCreacion";
    const UsuarioCreacion = "GSS_CentroCostos.UsuarioCreacion";
    const UsuarioModificacion = "GSS_CentroCostos.UsuarioModificacion";
    const FechaModificacion = "GSS_CentroCostos.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_CentroCostos.IdCeCostos AS IdCeCostos, ";
        $s_SQLQuery .= "GSS_CentroCostos.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "GSS_CentroCostos.Codigo AS Codigo, ";
        $s_SQLQuery .= "GSS_CentroCostos.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_CentroCostos.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_CentroCostos.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_CentroCostos.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "GSS_CentroCostos.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_CentroCostosBN */
    public function setByBN( GSS_CentroCostosBN $o_GSS_CentroCostosBN )
    {
        if ( !is_null( $o_GSS_CentroCostosBN->getIdCeCostos() ) )
        {
            $this->setIdCeCostos( $o_GSS_CentroCostosBN->getIdCeCostos() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_CentroCostosBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_CentroCostosBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_CentroCostosBN->getEstado() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_CentroCostosBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_CentroCostosBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_CentroCostosBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_CentroCostosBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_CentroCostosBN->getFechaModificacion() );
        }
    }

    /**
    * @return GSS_CentroCostosBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCeCostos )
    {
        if( is_null( $i_IdCeCostos ) ){ $i_IdCeCostos = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_CentroCostos ";
        $s_SQLQuery .= "WHERE IdCeCostos = ".$i_IdCeCostos." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_GSS_CentroCostosBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_CentroCostosBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_CentroCostosBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCeCostos() ) ) $s_SQLQuery .= "GSS_CentroCostos.IdCeCostos = ".$this->getIdCeCostos()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "GSS_CentroCostos.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "GSS_CentroCostos.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_CentroCostos.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_CentroCostos.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_CentroCostos.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_CentroCostos.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_CentroCostos.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_CentroCostos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_CentroCostosBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_CentroCostos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_GSS_CentroCostosBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_CentroCostosBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_CentroCostosBN[] = $o_GSS_CentroCostosBN;
            }
        }
        return $a_GSS_CentroCostosBN;
    }

    /* Devuelve un objeto GSS_CentroCostosBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_CentroCostos )
    {
        $o_GSS_CentroCostosBN = new GSS_CentroCostosBN();
        if ( !is_null( $a_GSS_CentroCostos['IdCeCostos'] ) ) $o_GSS_CentroCostosBN->setIdCeCostos( ( integer ) $a_GSS_CentroCostos['IdCeCostos'] );
        if ( !is_null( $a_GSS_CentroCostos['Descripcion'] ) ) $o_GSS_CentroCostosBN->setDescripcion( $a_GSS_CentroCostos['Descripcion'] );
        if ( !is_null( $a_GSS_CentroCostos['Codigo'] ) ) $o_GSS_CentroCostosBN->setCodigo( $a_GSS_CentroCostos['Codigo'] );
        if ( !is_null( $a_GSS_CentroCostos['Estado'] ) ) $o_GSS_CentroCostosBN->setEstado( $a_GSS_CentroCostos['Estado'] );
        if ( !is_null( $a_GSS_CentroCostos['FechaCreacion'] ) ) $o_GSS_CentroCostosBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_CentroCostos['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_CentroCostos['UsuarioCreacion'] ) ) $o_GSS_CentroCostosBN->setUsuarioCreacion( $a_GSS_CentroCostos['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_CentroCostos['UsuarioModificacion'] ) ) $o_GSS_CentroCostosBN->setUsuarioModificacion( $a_GSS_CentroCostos['UsuarioModificacion'] );
        if ( !is_null( $a_GSS_CentroCostos['FechaModificacion'] ) ) $o_GSS_CentroCostosBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_CentroCostos['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_GSS_CentroCostosBN;
    }
}
?>