<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Auditoria.xml */
/* Generado: 2022-04-18 21:14:55 */

/* Busqueda de registros de la tabla GSS_Auditoria. */
abstract class BaseGSS_AuditoriaFN extends GSS_AuditoriaBN
{
    /* Declaracion de constantes */
    const IdAuditoria = "GSS_Auditoria.IdAuditoria";
    const IdCompania = "GSS_Auditoria.IdCompania";
    const Modulo = "GSS_Auditoria.Modulo";
    const Sentencia = "GSS_Auditoria.Sentencia";
    const FechaCreacion = "GSS_Auditoria.FechaCreacion";
    const UsuarioCreacion = "GSS_Auditoria.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_Auditoria.IdAuditoria AS IdAuditoria, ";
        $s_SQLQuery .= "GSS_Auditoria.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_Auditoria.Modulo AS Modulo, ";
        $s_SQLQuery .= "GSS_Auditoria.Sentencia AS Sentencia, ";
        $s_SQLQuery .= "GSS_Auditoria.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_Auditoria.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_AuditoriaBN */
    public function setByBN( GSS_AuditoriaBN $o_GSS_AuditoriaBN )
    {
        if ( !is_null( $o_GSS_AuditoriaBN->getIdAuditoria() ) )
        {
            $this->setIdAuditoria( $o_GSS_AuditoriaBN->getIdAuditoria() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_AuditoriaBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getModulo() ) )
        {
            $this->setModulo( $o_GSS_AuditoriaBN->getModulo() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getSentencia() ) )
        {
            $this->setSentencia( $o_GSS_AuditoriaBN->getSentencia() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_AuditoriaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_AuditoriaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_AuditoriaBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return GSS_AuditoriaBN|null
    * @throws SQLException
    */
    public function selectByPK(  )
    {
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Auditoria ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_GSS_AuditoriaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_AuditoriaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_AuditoriaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdAuditoria() ) ) $s_SQLQuery .= "GSS_Auditoria.IdAuditoria = ".$this->getIdAuditoria()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_Auditoria.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getModulo() ) ) $s_SQLQuery .= "GSS_Auditoria.Modulo = '".$this->getModulo()."' AND ";
        if ( !is_null( $this->getSentencia() ) ) $s_SQLQuery .= "GSS_Auditoria.Sentencia = '".$this->getSentencia()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_Auditoria.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_Auditoria.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_Auditoria WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_AuditoriaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Auditoria WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_GSS_AuditoriaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_AuditoriaBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_AuditoriaBN[] = $o_GSS_AuditoriaBN;
            }
        }
        return $a_GSS_AuditoriaBN;
    }

    /* Devuelve un objeto GSS_AuditoriaBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_Auditoria )
    {
        $o_GSS_AuditoriaBN = new GSS_AuditoriaBN();
        if ( !is_null( $a_GSS_Auditoria['IdAuditoria'] ) ) $o_GSS_AuditoriaBN->setIdAuditoria( ( integer ) $a_GSS_Auditoria['IdAuditoria'] );
        if ( !is_null( $a_GSS_Auditoria['IdCompania'] ) ) $o_GSS_AuditoriaBN->setIdCompania( ( integer ) $a_GSS_Auditoria['IdCompania'] );
        if ( !is_null( $a_GSS_Auditoria['Modulo'] ) ) $o_GSS_AuditoriaBN->setModulo( $a_GSS_Auditoria['Modulo'] );
        if ( !is_null( $a_GSS_Auditoria['Sentencia'] ) ) $o_GSS_AuditoriaBN->setSentencia( $a_GSS_Auditoria['Sentencia'] );
        if ( !is_null( $a_GSS_Auditoria['FechaCreacion'] ) ) $o_GSS_AuditoriaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_Auditoria['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Auditoria['UsuarioCreacion'] ) ) $o_GSS_AuditoriaBN->setUsuarioCreacion( $a_GSS_Auditoria['UsuarioCreacion'] );
        return $o_GSS_AuditoriaBN;
    }
}
?>