<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_Cierre.xml */
/* Generado: 2022-04-18 21:14:55 */

/* Busqueda de registros de la tabla FCO_Cierre. */
abstract class BaseFCO_CierreFN extends FCO_CierreBN
{
    /* Declaracion de constantes */
    const IdCierre = "FCO_Cierre.IdCierre";
    const IdCompania = "FCO_Cierre.IdCompania";
    const IdSucursal = "FCO_Cierre.IdSucursal";
    const IdCaja = "FCO_Cierre.IdCaja";
    const IdTurno = "FCO_Cierre.IdTurno";
    const CodVendedor = "FCO_Cierre.CodVendedor";
    const Periodo = "FCO_Cierre.Periodo";
    const FechaCierre = "FCO_Cierre.FechaCierre";
    const TotalSoles = "FCO_Cierre.TotalSoles";
    const TotalDolares = "FCO_Cierre.TotalDolares";
    const Estado = "FCO_Cierre.Estado";
    const Observaciones = "FCO_Cierre.Observaciones";
    const FechaCreacion = "FCO_Cierre.FechaCreacion";
    const UsuarioCreacion = "FCO_Cierre.UsuarioCreacion";
    const FechaModificacion = "FCO_Cierre.FechaModificacion";
    const UsuarioModificacion = "FCO_Cierre.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_Cierre.IdCierre AS IdCierre, ";
        $s_SQLQuery .= "FCO_Cierre.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "FCO_Cierre.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "FCO_Cierre.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "FCO_Cierre.IdTurno AS IdTurno, ";
        $s_SQLQuery .= "FCO_Cierre.CodVendedor AS CodVendedor, ";
        $s_SQLQuery .= "FCO_Cierre.Periodo AS Periodo, ";
        $s_SQLQuery .= "FCO_Cierre.FechaCierre AS FechaCierre, ";
        $s_SQLQuery .= "FCO_Cierre.TotalSoles AS TotalSoles, ";
        $s_SQLQuery .= "FCO_Cierre.TotalDolares AS TotalDolares, ";
        $s_SQLQuery .= "FCO_Cierre.Estado AS Estado, ";
        $s_SQLQuery .= "FCO_Cierre.Observaciones AS Observaciones, ";
        $s_SQLQuery .= "FCO_Cierre.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_Cierre.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_Cierre.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_Cierre.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_CierreBN */
    public function setByBN( FCO_CierreBN $o_FCO_CierreBN )
    {
        if ( !is_null( $o_FCO_CierreBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_FCO_CierreBN->getIdCierre() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_CierreBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_CierreBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_FCO_CierreBN->getIdCaja() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_FCO_CierreBN->getIdTurno() );
        }
        if ( !is_null( $o_FCO_CierreBN->getCodVendedor() ) )
        {
            $this->setCodVendedor( $o_FCO_CierreBN->getCodVendedor() );
        }
        if ( !is_null( $o_FCO_CierreBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_FCO_CierreBN->getPeriodo() );
        }
        if ( !is_null( $o_FCO_CierreBN->getFechaCierre() ) )
        {
            $this->setFechaCierre( $o_FCO_CierreBN->getFechaCierre() );
        }
        if ( !is_null( $o_FCO_CierreBN->getTotalSoles() ) )
        {
            $this->setTotalSoles( $o_FCO_CierreBN->getTotalSoles() );
        }
        if ( !is_null( $o_FCO_CierreBN->getTotalDolares() ) )
        {
            $this->setTotalDolares( $o_FCO_CierreBN->getTotalDolares() );
        }
        if ( !is_null( $o_FCO_CierreBN->getEstado() ) )
        {
            $this->setEstado( $o_FCO_CierreBN->getEstado() );
        }
        if ( !is_null( $o_FCO_CierreBN->getObservaciones() ) )
        {
            $this->setObservaciones( $o_FCO_CierreBN->getObservaciones() );
        }
        if ( !is_null( $o_FCO_CierreBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CierreBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CierreBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CierreBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CierreBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CierreBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CierreBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CierreBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_CierreBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCierre )
    {
        if( is_null( $i_IdCierre ) ){ $i_IdCierre = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_Cierre ";
        $s_SQLQuery .= "WHERE IdCierre = ".$i_IdCierre." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_FCO_CierreBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_CierreBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_CierreBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCierre() ) ) $s_SQLQuery .= "FCO_Cierre.IdCierre = ".$this->getIdCierre()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "FCO_Cierre.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "FCO_Cierre.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "FCO_Cierre.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getIdTurno() ) ) $s_SQLQuery .= "FCO_Cierre.IdTurno = ".$this->getIdTurno()." AND ";
        if ( !is_null( $this->getCodVendedor() ) ) $s_SQLQuery .= "FCO_Cierre.CodVendedor = '".$this->getCodVendedor()."' AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "FCO_Cierre.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getFechaCierre() ) ) $s_SQLQuery .= "FCO_Cierre.FechaCierre = '".$this->getFechaCierre()."' AND ";
        if ( !is_null( $this->getTotalSoles() ) ) $s_SQLQuery .= "FCO_Cierre.TotalSoles = ".$this->getTotalSoles()." AND ";
        if ( !is_null( $this->getTotalDolares() ) ) $s_SQLQuery .= "FCO_Cierre.TotalDolares = ".$this->getTotalDolares()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "FCO_Cierre.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getObservaciones() ) ) $s_SQLQuery .= "FCO_Cierre.Observaciones = '".$this->getObservaciones()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_Cierre.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_Cierre.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_Cierre.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_Cierre.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_Cierre WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_CierreBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_Cierre WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_FCO_CierreBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_CierreBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_CierreBN[] = $o_FCO_CierreBN;
            }
        }
        return $a_FCO_CierreBN;
    }

    /* Devuelve un objeto FCO_CierreBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_Cierre )
    {
        $o_FCO_CierreBN = new FCO_CierreBN();
        if ( !is_null( $a_FCO_Cierre['IdCierre'] ) ) $o_FCO_CierreBN->setIdCierre( ( integer ) $a_FCO_Cierre['IdCierre'] );
        if ( !is_null( $a_FCO_Cierre['IdCompania'] ) ) $o_FCO_CierreBN->setIdCompania( ( integer ) $a_FCO_Cierre['IdCompania'] );
        if ( !is_null( $a_FCO_Cierre['IdSucursal'] ) ) $o_FCO_CierreBN->setIdSucursal( ( integer ) $a_FCO_Cierre['IdSucursal'] );
        if ( !is_null( $a_FCO_Cierre['IdCaja'] ) ) $o_FCO_CierreBN->setIdCaja( ( integer ) $a_FCO_Cierre['IdCaja'] );
        if ( !is_null( $a_FCO_Cierre['IdTurno'] ) ) $o_FCO_CierreBN->setIdTurno( ( integer ) $a_FCO_Cierre['IdTurno'] );
        if ( !is_null( $a_FCO_Cierre['CodVendedor'] ) ) $o_FCO_CierreBN->setCodVendedor( $a_FCO_Cierre['CodVendedor'] );
        if ( !is_null( $a_FCO_Cierre['Periodo'] ) ) $o_FCO_CierreBN->setPeriodo( $a_FCO_Cierre['Periodo'] );
        if ( !is_null( $a_FCO_Cierre['FechaCierre'] ) ) $o_FCO_CierreBN->setFechaCierre( utilTimestamp::getTimestamp( $a_FCO_Cierre['FechaCierre'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Cierre['TotalSoles'] ) ) $o_FCO_CierreBN->setTotalSoles( ( float ) $a_FCO_Cierre['TotalSoles'] );
        if ( !is_null( $a_FCO_Cierre['TotalDolares'] ) ) $o_FCO_CierreBN->setTotalDolares( ( float ) $a_FCO_Cierre['TotalDolares'] );
        if ( !is_null( $a_FCO_Cierre['Estado'] ) ) $o_FCO_CierreBN->setEstado( $a_FCO_Cierre['Estado'] );
        if ( !is_null( $a_FCO_Cierre['Observaciones'] ) ) $o_FCO_CierreBN->setObservaciones( $a_FCO_Cierre['Observaciones'] );
        if ( !is_null( $a_FCO_Cierre['FechaCreacion'] ) ) $o_FCO_CierreBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_Cierre['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Cierre['UsuarioCreacion'] ) ) $o_FCO_CierreBN->setUsuarioCreacion( $a_FCO_Cierre['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_Cierre['FechaModificacion'] ) ) $o_FCO_CierreBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_Cierre['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Cierre['UsuarioModificacion'] ) ) $o_FCO_CierreBN->setUsuarioModificacion( $a_FCO_Cierre['UsuarioModificacion'] );
        return $o_FCO_CierreBN;
    }
}
?>