<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_CajaUsuario.xml */
/* Generado: 2022-04-18 21:14:54 */

/* Busqueda de registros de la tabla FCO_CajaUsuario. */
abstract class BaseFCO_CajaUsuarioFN extends FCO_CajaUsuarioBN
{
    /* Declaracion de constantes */
    const IdCaja = "FCO_CajaUsuario.IdCaja";
    const IdUsuario = "FCO_CajaUsuario.IdUsuario";
    const IdCompania = "FCO_CajaUsuario.IdCompania";
    const IdSucursal = "FCO_CajaUsuario.IdSucursal";
    const EnUsoFlag = "FCO_CajaUsuario.EnUsoFlag";
    const FechaCreacion = "FCO_CajaUsuario.FechaCreacion";
    const UsuarioCreacion = "FCO_CajaUsuario.UsuarioCreacion";
    const FechaModificacion = "FCO_CajaUsuario.FechaModificacion";
    const UsuarioModificacion = "FCO_CajaUsuario.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_CajaUsuario.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "FCO_CajaUsuario.IdUsuario AS IdUsuario, ";
        $s_SQLQuery .= "FCO_CajaUsuario.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "FCO_CajaUsuario.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "FCO_CajaUsuario.EnUsoFlag AS EnUsoFlag, ";
        $s_SQLQuery .= "FCO_CajaUsuario.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_CajaUsuario.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_CajaUsuario.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_CajaUsuario.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_CajaUsuarioBN */
    public function setByBN( FCO_CajaUsuarioBN $o_FCO_CajaUsuarioBN )
    {
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_FCO_CajaUsuarioBN->getIdCaja() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_FCO_CajaUsuarioBN->getIdUsuario() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_CajaUsuarioBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_CajaUsuarioBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getEnUsoFlag() ) )
        {
            $this->setEnUsoFlag( $o_FCO_CajaUsuarioBN->getEnUsoFlag() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CajaUsuarioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CajaUsuarioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CajaUsuarioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CajaUsuarioBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_CajaUsuarioBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCaja, $s_IdUsuario, $i_IdCompania, $i_IdSucursal )
    {
        if( is_null( $i_IdCaja ) ){ $i_IdCaja = -1; } 
        if( is_null( $s_IdUsuario ) ){ $s_IdUsuario = '-1'; } 
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $i_IdSucursal ) ){ $i_IdSucursal = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_CajaUsuario ";
        $s_SQLQuery .= "WHERE IdCaja = ".$i_IdCaja." ";
        $s_SQLQuery .= "AND IdUsuario = '".$s_IdUsuario."' ";
        $s_SQLQuery .= "AND IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdSucursal = ".$i_IdSucursal." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_FCO_CajaUsuarioBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_CajaUsuarioBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_CajaUsuarioBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "FCO_CajaUsuario.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "FCO_CajaUsuario.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "FCO_CajaUsuario.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "FCO_CajaUsuario.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getEnUsoFlag() ) ) $s_SQLQuery .= "FCO_CajaUsuario.EnUsoFlag = ".$this->getEnUsoFlag()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_CajaUsuario.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_CajaUsuario.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_CajaUsuario.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_CajaUsuario.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_CajaUsuario WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_CajaUsuarioBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_CajaUsuario WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_FCO_CajaUsuarioBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_CajaUsuarioBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_CajaUsuarioBN[] = $o_FCO_CajaUsuarioBN;
            }
        }
        return $a_FCO_CajaUsuarioBN;
    }

    /* Devuelve un objeto FCO_CajaUsuarioBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_CajaUsuario )
    {
        $o_FCO_CajaUsuarioBN = new FCO_CajaUsuarioBN();
        if ( !is_null( $a_FCO_CajaUsuario['IdCaja'] ) ) $o_FCO_CajaUsuarioBN->setIdCaja( ( integer ) $a_FCO_CajaUsuario['IdCaja'] );
        if ( !is_null( $a_FCO_CajaUsuario['IdUsuario'] ) ) $o_FCO_CajaUsuarioBN->setIdUsuario( $a_FCO_CajaUsuario['IdUsuario'] );
        if ( !is_null( $a_FCO_CajaUsuario['IdCompania'] ) ) $o_FCO_CajaUsuarioBN->setIdCompania( ( integer ) $a_FCO_CajaUsuario['IdCompania'] );
        if ( !is_null( $a_FCO_CajaUsuario['IdSucursal'] ) ) $o_FCO_CajaUsuarioBN->setIdSucursal( ( integer ) $a_FCO_CajaUsuario['IdSucursal'] );
        if ( !is_null( $a_FCO_CajaUsuario['EnUsoFlag'] ) ) $o_FCO_CajaUsuarioBN->setEnUsoFlag( ( integer ) $a_FCO_CajaUsuario['EnUsoFlag'] );
        if ( !is_null( $a_FCO_CajaUsuario['FechaCreacion'] ) ) $o_FCO_CajaUsuarioBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_CajaUsuario['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_CajaUsuario['UsuarioCreacion'] ) ) $o_FCO_CajaUsuarioBN->setUsuarioCreacion( $a_FCO_CajaUsuario['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_CajaUsuario['FechaModificacion'] ) ) $o_FCO_CajaUsuarioBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_CajaUsuario['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_CajaUsuario['UsuarioModificacion'] ) ) $o_FCO_CajaUsuarioBN->setUsuarioModificacion( $a_FCO_CajaUsuario['UsuarioModificacion'] );
        return $o_FCO_CajaUsuarioBN;
    }
}
?>