<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_Caja.xml */
/* Generado: 2022-04-18 21:14:54 */

/* Busqueda de registros de la tabla FCO_Caja. */
abstract class BaseFCO_CajaFN extends FCO_CajaBN
{
    /* Declaracion de constantes */
    const IdCaja = "FCO_Caja.IdCaja";
    const IdCompania = "FCO_Caja.IdCompania";
    const IdSucursal = "FCO_Caja.IdSucursal";
    const Descripcion = "FCO_Caja.Descripcion";
    const Estado = "FCO_Caja.Estado";
    const FechaCreacion = "FCO_Caja.FechaCreacion";
    const UsuarioCreacion = "FCO_Caja.UsuarioCreacion";
    const FechaModificacion = "FCO_Caja.FechaModificacion";
    const UsuarioModificacion = "FCO_Caja.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_Caja.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "FCO_Caja.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "FCO_Caja.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "FCO_Caja.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "FCO_Caja.Estado AS Estado, ";
        $s_SQLQuery .= "FCO_Caja.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_Caja.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_Caja.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_Caja.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_CajaBN */
    public function setByBN( FCO_CajaBN $o_FCO_CajaBN )
    {
        if ( !is_null( $o_FCO_CajaBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_FCO_CajaBN->getIdCaja() );
        }
        if ( !is_null( $o_FCO_CajaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_CajaBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_CajaBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_CajaBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_CajaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_FCO_CajaBN->getDescripcion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getEstado() ) )
        {
            $this->setEstado( $o_FCO_CajaBN->getEstado() );
        }
        if ( !is_null( $o_FCO_CajaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CajaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CajaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CajaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CajaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_CajaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCaja )
    {
        if( is_null( $i_IdCaja ) ){ $i_IdCaja = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_Caja ";
        $s_SQLQuery .= "WHERE IdCaja = ".$i_IdCaja." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_FCO_CajaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_CajaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_CajaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "FCO_Caja.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "FCO_Caja.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "FCO_Caja.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "FCO_Caja.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "FCO_Caja.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_Caja.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_Caja.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_Caja.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_Caja.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_Caja WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_CajaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_Caja WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_FCO_CajaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_CajaBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_CajaBN[] = $o_FCO_CajaBN;
            }
        }
        return $a_FCO_CajaBN;
    }

    /* Devuelve un objeto FCO_CajaBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_Caja )
    {
        $o_FCO_CajaBN = new FCO_CajaBN();
        if ( !is_null( $a_FCO_Caja['IdCaja'] ) ) $o_FCO_CajaBN->setIdCaja( ( integer ) $a_FCO_Caja['IdCaja'] );
        if ( !is_null( $a_FCO_Caja['IdCompania'] ) ) $o_FCO_CajaBN->setIdCompania( ( integer ) $a_FCO_Caja['IdCompania'] );
        if ( !is_null( $a_FCO_Caja['IdSucursal'] ) ) $o_FCO_CajaBN->setIdSucursal( ( integer ) $a_FCO_Caja['IdSucursal'] );
        if ( !is_null( $a_FCO_Caja['Descripcion'] ) ) $o_FCO_CajaBN->setDescripcion( $a_FCO_Caja['Descripcion'] );
        if ( !is_null( $a_FCO_Caja['Estado'] ) ) $o_FCO_CajaBN->setEstado( $a_FCO_Caja['Estado'] );
        if ( !is_null( $a_FCO_Caja['FechaCreacion'] ) ) $o_FCO_CajaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_Caja['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Caja['UsuarioCreacion'] ) ) $o_FCO_CajaBN->setUsuarioCreacion( $a_FCO_Caja['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_Caja['FechaModificacion'] ) ) $o_FCO_CajaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_Caja['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Caja['UsuarioModificacion'] ) ) $o_FCO_CajaBN->setUsuarioModificacion( $a_FCO_Caja['UsuarioModificacion'] );
        return $o_FCO_CajaBN;
    }
}
?>