<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_Terminos.xml */
/* Generado: 2022-04-18 21:14:54 */

/* Busqueda de registros de la tabla CP_Terminos. */
abstract class BaseCP_TerminosFN extends CP_TerminosBN
{
    /* Declaracion de constantes */
    const TerminoId = "CP_Terminos.TerminoId";
    const Nombre = "CP_Terminos.Nombre";
    const Descripcion = "CP_Terminos.Descripcion";
    const Cantidad = "CP_Terminos.Cantidad";
    const Estado = "CP_Terminos.Estado";
    const UsuarioCreacion = "CP_Terminos.UsuarioCreacion";
    const FechaCreacion = "CP_Terminos.FechaCreacion";
    const UsuarioModificacion = "CP_Terminos.UsuarioModificacion";
    const FechaModificacion = "CP_Terminos.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CP_Terminos.TerminoId AS TerminoId, ";
        $s_SQLQuery .= "CP_Terminos.Nombre AS Nombre, ";
        $s_SQLQuery .= "CP_Terminos.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CP_Terminos.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "CP_Terminos.Estado AS Estado, ";
        $s_SQLQuery .= "CP_Terminos.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CP_Terminos.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CP_Terminos.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "CP_Terminos.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CP_TerminosBN */
    public function setByBN( CP_TerminosBN $o_CP_TerminosBN )
    {
        if ( !is_null( $o_CP_TerminosBN->getTerminoId() ) )
        {
            $this->setTerminoId( $o_CP_TerminosBN->getTerminoId() );
        }
        if ( !is_null( $o_CP_TerminosBN->getNombre() ) )
        {
            $this->setNombre( $o_CP_TerminosBN->getNombre() );
        }
        if ( !is_null( $o_CP_TerminosBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CP_TerminosBN->getDescripcion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getCantidad() ) )
        {
            $this->setCantidad( $o_CP_TerminosBN->getCantidad() );
        }
        if ( !is_null( $o_CP_TerminosBN->getEstado() ) )
        {
            $this->setEstado( $o_CP_TerminosBN->getEstado() );
        }
        if ( !is_null( $o_CP_TerminosBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CP_TerminosBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CP_TerminosBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CP_TerminosBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CP_TerminosBN->getFechaModificacion() );
        }
    }

    /**
    * @return CP_TerminosBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_TerminoId )
    {
        if( is_null( $i_TerminoId ) ){ $i_TerminoId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_Terminos ";
        $s_SQLQuery .= "WHERE TerminoId = ".$i_TerminoId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CP_TerminosBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CP_TerminosBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CP_TerminosBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getTerminoId() ) ) $s_SQLQuery .= "CP_Terminos.TerminoId = ".$this->getTerminoId()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "CP_Terminos.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CP_Terminos.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "CP_Terminos.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CP_Terminos.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CP_Terminos.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CP_Terminos.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CP_Terminos.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CP_Terminos.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CP_Terminos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CP_TerminosBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_Terminos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CP_TerminosBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CP_TerminosBN = $this->insertObjectBN( $a_SQLRow );
                $a_CP_TerminosBN[] = $o_CP_TerminosBN;
            }
        }
        return $a_CP_TerminosBN;
    }

    /* Devuelve un objeto CP_TerminosBN desde un objeto propel */
    public function insertObjectBN( $a_CP_Terminos )
    {
        $o_CP_TerminosBN = new CP_TerminosBN();
        if ( !is_null( $a_CP_Terminos['TerminoId'] ) ) $o_CP_TerminosBN->setTerminoId( ( integer ) $a_CP_Terminos['TerminoId'] );
        if ( !is_null( $a_CP_Terminos['Nombre'] ) ) $o_CP_TerminosBN->setNombre( $a_CP_Terminos['Nombre'] );
        if ( !is_null( $a_CP_Terminos['Descripcion'] ) ) $o_CP_TerminosBN->setDescripcion( $a_CP_Terminos['Descripcion'] );
        if ( !is_null( $a_CP_Terminos['Cantidad'] ) ) $o_CP_TerminosBN->setCantidad( ( integer ) $a_CP_Terminos['Cantidad'] );
        if ( !is_null( $a_CP_Terminos['Estado'] ) ) $o_CP_TerminosBN->setEstado( $a_CP_Terminos['Estado'] );
        if ( !is_null( $a_CP_Terminos['UsuarioCreacion'] ) ) $o_CP_TerminosBN->setUsuarioCreacion( $a_CP_Terminos['UsuarioCreacion'] );
        if ( !is_null( $a_CP_Terminos['FechaCreacion'] ) ) $o_CP_TerminosBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CP_Terminos['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_Terminos['UsuarioModificacion'] ) ) $o_CP_TerminosBN->setUsuarioModificacion( $a_CP_Terminos['UsuarioModificacion'] );
        if ( !is_null( $a_CP_Terminos['FechaModificacion'] ) ) $o_CP_TerminosBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CP_Terminos['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_CP_TerminosBN;
    }
}
?>