<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_MetodosPago.xml */
/* Generado: 2022-04-18 21:14:54 */

/* Busqueda de registros de la tabla CP_MetodosPago. */
abstract class BaseCP_MetodosPagoFN extends CP_MetodosPagoBN
{
    /* Declaracion de constantes */
    const MetodoPagoId = "CP_MetodosPago.MetodoPagoId";
    const Nombre = "CP_MetodosPago.Nombre";
    const Descripcion = "CP_MetodosPago.Descripcion";
    const Estado = "CP_MetodosPago.Estado";
    const UsuarioCreacion = "CP_MetodosPago.UsuarioCreacion";
    const FechaCreacion = "CP_MetodosPago.FechaCreacion";
    const UsuarioModificacion = "CP_MetodosPago.UsuarioModificacion";
    const FechaModificacion = "CP_MetodosPago.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CP_MetodosPago.MetodoPagoId AS MetodoPagoId, ";
        $s_SQLQuery .= "CP_MetodosPago.Nombre AS Nombre, ";
        $s_SQLQuery .= "CP_MetodosPago.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CP_MetodosPago.Estado AS Estado, ";
        $s_SQLQuery .= "CP_MetodosPago.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CP_MetodosPago.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CP_MetodosPago.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "CP_MetodosPago.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CP_MetodosPagoBN */
    public function setByBN( CP_MetodosPagoBN $o_CP_MetodosPagoBN )
    {
        if ( !is_null( $o_CP_MetodosPagoBN->getMetodoPagoId() ) )
        {
            $this->setMetodoPagoId( $o_CP_MetodosPagoBN->getMetodoPagoId() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getNombre() ) )
        {
            $this->setNombre( $o_CP_MetodosPagoBN->getNombre() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CP_MetodosPagoBN->getDescripcion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getEstado() ) )
        {
            $this->setEstado( $o_CP_MetodosPagoBN->getEstado() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CP_MetodosPagoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CP_MetodosPagoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CP_MetodosPagoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CP_MetodosPagoBN->getFechaModificacion() );
        }
    }

    /**
    * @return CP_MetodosPagoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MetodoPagoId )
    {
        if( is_null( $i_MetodoPagoId ) ){ $i_MetodoPagoId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_MetodosPago ";
        $s_SQLQuery .= "WHERE MetodoPagoId = ".$i_MetodoPagoId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CP_MetodosPagoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CP_MetodosPagoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CP_MetodosPagoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMetodoPagoId() ) ) $s_SQLQuery .= "CP_MetodosPago.MetodoPagoId = ".$this->getMetodoPagoId()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "CP_MetodosPago.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CP_MetodosPago.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CP_MetodosPago.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CP_MetodosPago.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CP_MetodosPago.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CP_MetodosPago.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CP_MetodosPago.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CP_MetodosPago WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CP_MetodosPagoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_MetodosPago WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CP_MetodosPagoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CP_MetodosPagoBN = $this->insertObjectBN( $a_SQLRow );
                $a_CP_MetodosPagoBN[] = $o_CP_MetodosPagoBN;
            }
        }
        return $a_CP_MetodosPagoBN;
    }

    /* Devuelve un objeto CP_MetodosPagoBN desde un objeto propel */
    public function insertObjectBN( $a_CP_MetodosPago )
    {
        $o_CP_MetodosPagoBN = new CP_MetodosPagoBN();
        if ( !is_null( $a_CP_MetodosPago['MetodoPagoId'] ) ) $o_CP_MetodosPagoBN->setMetodoPagoId( ( integer ) $a_CP_MetodosPago['MetodoPagoId'] );
        if ( !is_null( $a_CP_MetodosPago['Nombre'] ) ) $o_CP_MetodosPagoBN->setNombre( $a_CP_MetodosPago['Nombre'] );
        if ( !is_null( $a_CP_MetodosPago['Descripcion'] ) ) $o_CP_MetodosPagoBN->setDescripcion( $a_CP_MetodosPago['Descripcion'] );
        if ( !is_null( $a_CP_MetodosPago['Estado'] ) ) $o_CP_MetodosPagoBN->setEstado( $a_CP_MetodosPago['Estado'] );
        if ( !is_null( $a_CP_MetodosPago['UsuarioCreacion'] ) ) $o_CP_MetodosPagoBN->setUsuarioCreacion( $a_CP_MetodosPago['UsuarioCreacion'] );
        if ( !is_null( $a_CP_MetodosPago['FechaCreacion'] ) ) $o_CP_MetodosPagoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CP_MetodosPago['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_MetodosPago['UsuarioModificacion'] ) ) $o_CP_MetodosPagoBN->setUsuarioModificacion( $a_CP_MetodosPago['UsuarioModificacion'] );
        if ( !is_null( $a_CP_MetodosPago['FechaModificacion'] ) ) $o_CP_MetodosPagoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CP_MetodosPago['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_CP_MetodosPagoBN;
    }
}
?>