<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CAR_VehiculoTipo.xml */
/* Generado: 2025-01-03 23:08:18 */

/* Busqueda de registros de la tabla CAR_VehiculoTipo. */
abstract class BaseCAR_VehiculoTipoFN extends CAR_VehiculoTipoBN
{
    /* Declaracion de constantes */
    const IdVehiculoTipo = "CAR_VehiculoTipo.IdVehiculoTipo";
    const Descripcion = "CAR_VehiculoTipo.Descripcion";
    const NumeroRuedas = "CAR_VehiculoTipo.NumeroRuedas";
    const IdCartera = "CAR_VehiculoTipo.IdCartera";
    const Estado = "CAR_VehiculoTipo.Estado";
    const FechaCreacion = "CAR_VehiculoTipo.FechaCreacion";
    const UsuarioCreacion = "CAR_VehiculoTipo.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CAR_VehiculoTipo.IdVehiculoTipo AS IdVehiculoTipo, ";
        $s_SQLQuery .= "CAR_VehiculoTipo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CAR_VehiculoTipo.NumeroRuedas AS NumeroRuedas, ";
        $s_SQLQuery .= "CAR_VehiculoTipo.IdCartera AS IdCartera, ";
        $s_SQLQuery .= "CAR_VehiculoTipo.Estado AS Estado, ";
        $s_SQLQuery .= "CAR_VehiculoTipo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CAR_VehiculoTipo.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CAR_VehiculoTipoBN */
    public function setByBN( CAR_VehiculoTipoBN $o_CAR_VehiculoTipoBN )
    {
        if ( !is_null( $o_CAR_VehiculoTipoBN->getIdVehiculoTipo() ) )
        {
            $this->setIdVehiculoTipo( $o_CAR_VehiculoTipoBN->getIdVehiculoTipo() );
        }
        if ( !is_null( $o_CAR_VehiculoTipoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CAR_VehiculoTipoBN->getDescripcion() );
        }
        if ( !is_null( $o_CAR_VehiculoTipoBN->getNumeroRuedas() ) )
        {
            $this->setNumeroRuedas( $o_CAR_VehiculoTipoBN->getNumeroRuedas() );
        }
        if ( !is_null( $o_CAR_VehiculoTipoBN->getIdCartera() ) )
        {
            $this->setIdCartera( $o_CAR_VehiculoTipoBN->getIdCartera() );
        }
        if ( !is_null( $o_CAR_VehiculoTipoBN->getEstado() ) )
        {
            $this->setEstado( $o_CAR_VehiculoTipoBN->getEstado() );
        }
        if ( !is_null( $o_CAR_VehiculoTipoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CAR_VehiculoTipoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CAR_VehiculoTipoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CAR_VehiculoTipoBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return CAR_VehiculoTipoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdVehiculoTipo )
    {
        if( is_null( $i_IdVehiculoTipo ) ){ $i_IdVehiculoTipo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_VehiculoTipo ";
        $s_SQLQuery .= "WHERE IdVehiculoTipo = ".$i_IdVehiculoTipo." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CAR_VehiculoTipoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CAR_VehiculoTipoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CAR_VehiculoTipoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdVehiculoTipo() ) ) $s_SQLQuery .= "CAR_VehiculoTipo.IdVehiculoTipo = ".$this->getIdVehiculoTipo()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CAR_VehiculoTipo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getNumeroRuedas() ) ) $s_SQLQuery .= "CAR_VehiculoTipo.NumeroRuedas = ".$this->getNumeroRuedas()." AND ";
        if ( !is_null( $this->getIdCartera() ) ) $s_SQLQuery .= "CAR_VehiculoTipo.IdCartera = ".$this->getIdCartera()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CAR_VehiculoTipo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CAR_VehiculoTipo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CAR_VehiculoTipo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CAR_VehiculoTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CAR_VehiculoTipoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_VehiculoTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CAR_VehiculoTipoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CAR_VehiculoTipoBN = $this->insertObjectBN( $a_SQLRow );
                $a_CAR_VehiculoTipoBN[] = $o_CAR_VehiculoTipoBN;
            }
        }
        return $a_CAR_VehiculoTipoBN;
    }

    /* Devuelve un objeto CAR_VehiculoTipoBN desde un objeto propel */
    public function insertObjectBN( $a_CAR_VehiculoTipo )
    {
        $o_CAR_VehiculoTipoBN = new CAR_VehiculoTipoBN();
        if ( !is_null( $a_CAR_VehiculoTipo['IdVehiculoTipo'] ) ) $o_CAR_VehiculoTipoBN->setIdVehiculoTipo( ( integer ) $a_CAR_VehiculoTipo['IdVehiculoTipo'] );
        if ( !is_null( $a_CAR_VehiculoTipo['Descripcion'] ) ) $o_CAR_VehiculoTipoBN->setDescripcion( $a_CAR_VehiculoTipo['Descripcion'] );
        if ( !is_null( $a_CAR_VehiculoTipo['NumeroRuedas'] ) ) $o_CAR_VehiculoTipoBN->setNumeroRuedas( ( integer ) $a_CAR_VehiculoTipo['NumeroRuedas'] );
        if ( !is_null( $a_CAR_VehiculoTipo['IdCartera'] ) ) $o_CAR_VehiculoTipoBN->setIdCartera( ( integer ) $a_CAR_VehiculoTipo['IdCartera'] );
        if ( !is_null( $a_CAR_VehiculoTipo['Estado'] ) ) $o_CAR_VehiculoTipoBN->setEstado( $a_CAR_VehiculoTipo['Estado'] );
        if ( !is_null( $a_CAR_VehiculoTipo['FechaCreacion'] ) ) $o_CAR_VehiculoTipoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CAR_VehiculoTipo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_VehiculoTipo['UsuarioCreacion'] ) ) $o_CAR_VehiculoTipoBN->setUsuarioCreacion( $a_CAR_VehiculoTipo['UsuarioCreacion'] );
        return $o_CAR_VehiculoTipoBN;
    }
}
?>