<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CAR_VehiculoModelo.xml */
/* Generado: 2024-12-31 05:18:46 */

/* Busqueda de registros de la tabla CAR_VehiculoModelo. */
abstract class BaseCAR_VehiculoModeloFN extends CAR_VehiculoModeloBN
{
    /* Declaracion de constantes */
    const IdVehiculoModelo = "CAR_VehiculoModelo.IdVehiculoModelo";
    const IdVehiculoMarca = "CAR_VehiculoModelo.IdVehiculoMarca";
    const IdVehiculoTipo = "CAR_VehiculoModelo.IdVehiculoTipo";
    const Descripcion = "CAR_VehiculoModelo.Descripcion";
    const Codigo = "CAR_VehiculoModelo.Codigo";
    const Estado = "CAR_VehiculoModelo.Estado";
    const FechaCreacion = "CAR_VehiculoModelo.FechaCreacion";
    const UsuarioCreacion = "CAR_VehiculoModelo.UsuarioCreacion";
    const UsuarioModificacion = "CAR_VehiculoModelo.UsuarioModificacion";
    const FechaModificacion = "CAR_VehiculoModelo.FechaModificacion";
    const Eliminado = "CAR_VehiculoModelo.Eliminado";
    const FechaEliminado = "CAR_VehiculoModelo.FechaEliminado";
    const UsuarioEliminado = "CAR_VehiculoModelo.UsuarioEliminado";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CAR_VehiculoModelo.IdVehiculoModelo AS IdVehiculoModelo, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.IdVehiculoMarca AS IdVehiculoMarca, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.IdVehiculoTipo AS IdVehiculoTipo, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.Codigo AS Codigo, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.Estado AS Estado, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.Eliminado AS Eliminado, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.FechaEliminado AS FechaEliminado, ";
        $s_SQLQuery .= "CAR_VehiculoModelo.UsuarioEliminado AS UsuarioEliminado ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CAR_VehiculoModeloBN */
    public function setByBN( CAR_VehiculoModeloBN $o_CAR_VehiculoModeloBN )
    {
        if ( !is_null( $o_CAR_VehiculoModeloBN->getIdVehiculoModelo() ) )
        {
            $this->setIdVehiculoModelo( $o_CAR_VehiculoModeloBN->getIdVehiculoModelo() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getIdVehiculoMarca() ) )
        {
            $this->setIdVehiculoMarca( $o_CAR_VehiculoModeloBN->getIdVehiculoMarca() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getIdVehiculoTipo() ) )
        {
            $this->setIdVehiculoTipo( $o_CAR_VehiculoModeloBN->getIdVehiculoTipo() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CAR_VehiculoModeloBN->getDescripcion() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getCodigo() ) )
        {
            $this->setCodigo( $o_CAR_VehiculoModeloBN->getCodigo() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getEstado() ) )
        {
            $this->setEstado( $o_CAR_VehiculoModeloBN->getEstado() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CAR_VehiculoModeloBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CAR_VehiculoModeloBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CAR_VehiculoModeloBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CAR_VehiculoModeloBN->getFechaModificacion() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getEliminado() ) )
        {
            $this->setEliminado( $o_CAR_VehiculoModeloBN->getEliminado() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_CAR_VehiculoModeloBN->getFechaEliminado() );
        }
        if ( !is_null( $o_CAR_VehiculoModeloBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_CAR_VehiculoModeloBN->getUsuarioEliminado() );
        }
    }

    /**
    * @return CAR_VehiculoModeloBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdVehiculoModelo )
    {
        if( is_null( $i_IdVehiculoModelo ) ){ $i_IdVehiculoModelo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_VehiculoModelo ";
        $s_SQLQuery .= "WHERE IdVehiculoModelo = ".$i_IdVehiculoModelo." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_CAR_VehiculoModeloBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CAR_VehiculoModeloBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CAR_VehiculoModeloBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdVehiculoModelo() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.IdVehiculoModelo = ".$this->getIdVehiculoModelo()." AND ";
        if ( !is_null( $this->getIdVehiculoMarca() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.IdVehiculoMarca = ".$this->getIdVehiculoMarca()." AND ";
        if ( !is_null( $this->getIdVehiculoTipo() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.IdVehiculoTipo = ".$this->getIdVehiculoTipo()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getEliminado() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.Eliminado = ".$this->getEliminado()." AND ";
        if ( !is_null( $this->getFechaEliminado() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.FechaEliminado = '".$this->getFechaEliminado()."' AND ";
        if ( !is_null( $this->getUsuarioEliminado() ) ) $s_SQLQuery .= "CAR_VehiculoModelo.UsuarioEliminado = '".$this->getUsuarioEliminado()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CAR_VehiculoModelo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CAR_VehiculoModeloBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CAR_VehiculoModelo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_CAR_VehiculoModeloBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CAR_VehiculoModeloBN = $this->insertObjectBN( $a_SQLRow );
                $a_CAR_VehiculoModeloBN[] = $o_CAR_VehiculoModeloBN;
            }
        }
        return $a_CAR_VehiculoModeloBN;
    }

    /* Devuelve un objeto CAR_VehiculoModeloBN desde un objeto propel */
    public function insertObjectBN( $a_CAR_VehiculoModelo )
    {
        $o_CAR_VehiculoModeloBN = new CAR_VehiculoModeloBN();
        if ( !is_null( $a_CAR_VehiculoModelo['IdVehiculoModelo'] ) ) $o_CAR_VehiculoModeloBN->setIdVehiculoModelo( ( integer ) $a_CAR_VehiculoModelo['IdVehiculoModelo'] );
        if ( !is_null( $a_CAR_VehiculoModelo['IdVehiculoMarca'] ) ) $o_CAR_VehiculoModeloBN->setIdVehiculoMarca( ( integer ) $a_CAR_VehiculoModelo['IdVehiculoMarca'] );
        if ( !is_null( $a_CAR_VehiculoModelo['IdVehiculoTipo'] ) ) $o_CAR_VehiculoModeloBN->setIdVehiculoTipo( ( integer ) $a_CAR_VehiculoModelo['IdVehiculoTipo'] );
        if ( !is_null( $a_CAR_VehiculoModelo['Descripcion'] ) ) $o_CAR_VehiculoModeloBN->setDescripcion( $a_CAR_VehiculoModelo['Descripcion'] );
        if ( !is_null( $a_CAR_VehiculoModelo['Codigo'] ) ) $o_CAR_VehiculoModeloBN->setCodigo( $a_CAR_VehiculoModelo['Codigo'] );
        if ( !is_null( $a_CAR_VehiculoModelo['Estado'] ) ) $o_CAR_VehiculoModeloBN->setEstado( $a_CAR_VehiculoModelo['Estado'] );
        if ( !is_null( $a_CAR_VehiculoModelo['FechaCreacion'] ) ) $o_CAR_VehiculoModeloBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CAR_VehiculoModelo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_VehiculoModelo['UsuarioCreacion'] ) ) $o_CAR_VehiculoModeloBN->setUsuarioCreacion( $a_CAR_VehiculoModelo['UsuarioCreacion'] );
        if ( !is_null( $a_CAR_VehiculoModelo['UsuarioModificacion'] ) ) $o_CAR_VehiculoModeloBN->setUsuarioModificacion( $a_CAR_VehiculoModelo['UsuarioModificacion'] );
        if ( !is_null( $a_CAR_VehiculoModelo['FechaModificacion'] ) ) $o_CAR_VehiculoModeloBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CAR_VehiculoModelo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_VehiculoModelo['Eliminado'] ) ) $o_CAR_VehiculoModeloBN->setEliminado( ( integer ) $a_CAR_VehiculoModelo['Eliminado'] );
        if ( !is_null( $a_CAR_VehiculoModelo['FechaEliminado'] ) ) $o_CAR_VehiculoModeloBN->setFechaEliminado( utilTimestamp::getTimestamp( $a_CAR_VehiculoModelo['FechaEliminado'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CAR_VehiculoModelo['UsuarioEliminado'] ) ) $o_CAR_VehiculoModeloBN->setUsuarioEliminado( $a_CAR_VehiculoModelo['UsuarioEliminado'] );
        return $o_CAR_VehiculoModeloBN;
    }
}
?>