<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_VehiculoSucursal.xml */
/* Generado: 2022-04-18 21:14:53 */

/* Busqueda de registros de la tabla ALM_VehiculoSucursal. */
abstract class BaseALM_VehiculoSucursalFN extends ALM_VehiculoSucursalBN
{
    /* Declaracion de constantes */
    const IdVehiculoSucursal = "ALM_VehiculoSucursal.IdVehiculoSucursal";
    const IdSucursal = "ALM_VehiculoSucursal.IdSucursal";
    const Marca = "ALM_VehiculoSucursal.Marca";
    const Placa = "ALM_VehiculoSucursal.Placa";
    const Estado = "ALM_VehiculoSucursal.Estado";
    const UsuarioCreacion = "ALM_VehiculoSucursal.UsuarioCreacion";
    const FechaCreacion = "ALM_VehiculoSucursal.FechaCreacion";
    const UsuarioModificacion = "ALM_VehiculoSucursal.UsuarioModificacion";
    const FechaModificacion = "ALM_VehiculoSucursal.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_VehiculoSucursal.IdVehiculoSucursal AS IdVehiculoSucursal, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.Marca AS Marca, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.Placa AS Placa, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_VehiculoSucursal.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_VehiculoSucursalBN */
    public function setByBN( ALM_VehiculoSucursalBN $o_ALM_VehiculoSucursalBN )
    {
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getIdVehiculoSucursal() ) )
        {
            $this->setIdVehiculoSucursal( $o_ALM_VehiculoSucursalBN->getIdVehiculoSucursal() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_VehiculoSucursalBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getMarca() ) )
        {
            $this->setMarca( $o_ALM_VehiculoSucursalBN->getMarca() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getPlaca() ) )
        {
            $this->setPlaca( $o_ALM_VehiculoSucursalBN->getPlaca() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_VehiculoSucursalBN->getEstado() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_VehiculoSucursalBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_VehiculoSucursalBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_VehiculoSucursalBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_VehiculoSucursalBN->getFechaModificacion() );
        }
    }

    /**
    * @return ALM_VehiculoSucursalBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdVehiculoSucursal )
    {
        if( is_null( $i_IdVehiculoSucursal ) ){ $i_IdVehiculoSucursal = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_VehiculoSucursal ";
        $s_SQLQuery .= "WHERE IdVehiculoSucursal = ".$i_IdVehiculoSucursal." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_VehiculoSucursalBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_VehiculoSucursalBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_VehiculoSucursalBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdVehiculoSucursal() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.IdVehiculoSucursal = ".$this->getIdVehiculoSucursal()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getMarca() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.Marca = '".$this->getMarca()."' AND ";
        if ( !is_null( $this->getPlaca() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.Placa = '".$this->getPlaca()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_VehiculoSucursal.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_VehiculoSucursal WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_VehiculoSucursalBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_VehiculoSucursal WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_VehiculoSucursalBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_VehiculoSucursalBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_VehiculoSucursalBN[] = $o_ALM_VehiculoSucursalBN;
            }
        }
        return $a_ALM_VehiculoSucursalBN;
    }

    /* Devuelve un objeto ALM_VehiculoSucursalBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_VehiculoSucursal )
    {
        $o_ALM_VehiculoSucursalBN = new ALM_VehiculoSucursalBN();
        if ( !is_null( $a_ALM_VehiculoSucursal['IdVehiculoSucursal'] ) ) $o_ALM_VehiculoSucursalBN->setIdVehiculoSucursal( ( integer ) $a_ALM_VehiculoSucursal['IdVehiculoSucursal'] );
        if ( !is_null( $a_ALM_VehiculoSucursal['IdSucursal'] ) ) $o_ALM_VehiculoSucursalBN->setIdSucursal( ( integer ) $a_ALM_VehiculoSucursal['IdSucursal'] );
        if ( !is_null( $a_ALM_VehiculoSucursal['Marca'] ) ) $o_ALM_VehiculoSucursalBN->setMarca( $a_ALM_VehiculoSucursal['Marca'] );
        if ( !is_null( $a_ALM_VehiculoSucursal['Placa'] ) ) $o_ALM_VehiculoSucursalBN->setPlaca( $a_ALM_VehiculoSucursal['Placa'] );
        if ( !is_null( $a_ALM_VehiculoSucursal['Estado'] ) ) $o_ALM_VehiculoSucursalBN->setEstado( $a_ALM_VehiculoSucursal['Estado'] );
        if ( !is_null( $a_ALM_VehiculoSucursal['UsuarioCreacion'] ) ) $o_ALM_VehiculoSucursalBN->setUsuarioCreacion( $a_ALM_VehiculoSucursal['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_VehiculoSucursal['FechaCreacion'] ) ) $o_ALM_VehiculoSucursalBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_VehiculoSucursal['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_VehiculoSucursal['UsuarioModificacion'] ) ) $o_ALM_VehiculoSucursalBN->setUsuarioModificacion( $a_ALM_VehiculoSucursal['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_VehiculoSucursal['FechaModificacion'] ) ) $o_ALM_VehiculoSucursalBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_VehiculoSucursal['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_VehiculoSucursalBN;
    }
}
?>