<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransferenciaDetalle.xml */
/* Generado: 2022-04-18 21:14:52 */

/* Busqueda de registros de la tabla ALM_TransferenciaDetalle. */
abstract class BaseALM_TransferenciaDetalleFN extends ALM_TransferenciaDetalleBN
{
    /* Declaracion de constantes */
    const IdTransferencia = "ALM_TransferenciaDetalle.IdTransferencia";
    const IdSecuencia = "ALM_TransferenciaDetalle.IdSecuencia";
    const IdItem = "ALM_TransferenciaDetalle.IdItem";
    const IdLote = "ALM_TransferenciaDetalle.IdLote";
    const DescripcionItem = "ALM_TransferenciaDetalle.DescripcionItem";
    const UnidadCodigo = "ALM_TransferenciaDetalle.UnidadCodigo";
    const Cantidad = "ALM_TransferenciaDetalle.Cantidad";
    const CantidadRecepcionada = "ALM_TransferenciaDetalle.CantidadRecepcionada";
    const CantidadDoble = "ALM_TransferenciaDetalle.CantidadDoble";
    const PrecioUnitario = "ALM_TransferenciaDetalle.PrecioUnitario";
    const MontoTotal = "ALM_TransferenciaDetalle.MontoTotal";
    const PrecioUnitarioDolares = "ALM_TransferenciaDetalle.PrecioUnitarioDolares";
    const MontoTotalDolares = "ALM_TransferenciaDetalle.MontoTotalDolares";
    const FechaVencimiento = "ALM_TransferenciaDetalle.FechaVencimiento";
    const Observaciones = "ALM_TransferenciaDetalle.Observaciones";
    const Estado = "ALM_TransferenciaDetalle.Estado";
    const UsuarioCreacion = "ALM_TransferenciaDetalle.UsuarioCreacion";
    const FechaCreacion = "ALM_TransferenciaDetalle.FechaCreacion";
    const UsuarioModificacion = "ALM_TransferenciaDetalle.UsuarioModificacion";
    const FechaModificacion = "ALM_TransferenciaDetalle.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_TransferenciaDetalle.IdTransferencia AS IdTransferencia, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.DescripcionItem AS DescripcionItem, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.UnidadCodigo AS UnidadCodigo, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.CantidadRecepcionada AS CantidadRecepcionada, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.CantidadDoble AS CantidadDoble, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.PrecioUnitarioDolares AS PrecioUnitarioDolares, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.MontoTotalDolares AS MontoTotalDolares, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.Observaciones AS Observaciones, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_TransferenciaDetalle.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_TransferenciaDetalleBN */
    public function setByBN( ALM_TransferenciaDetalleBN $o_ALM_TransferenciaDetalleBN )
    {
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getIdTransferencia() ) )
        {
            $this->setIdTransferencia( $o_ALM_TransferenciaDetalleBN->getIdTransferencia() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_TransferenciaDetalleBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_TransferenciaDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_TransferenciaDetalleBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getDescripcionItem() ) )
        {
            $this->setDescripcionItem( $o_ALM_TransferenciaDetalleBN->getDescripcionItem() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getUnidadCodigo() ) )
        {
            $this->setUnidadCodigo( $o_ALM_TransferenciaDetalleBN->getUnidadCodigo() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getCantidad() ) )
        {
            $this->setCantidad( $o_ALM_TransferenciaDetalleBN->getCantidad() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getCantidadRecepcionada() ) )
        {
            $this->setCantidadRecepcionada( $o_ALM_TransferenciaDetalleBN->getCantidadRecepcionada() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getCantidadDoble() ) )
        {
            $this->setCantidadDoble( $o_ALM_TransferenciaDetalleBN->getCantidadDoble() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_ALM_TransferenciaDetalleBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_ALM_TransferenciaDetalleBN->getMontoTotal() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getPrecioUnitarioDolares() ) )
        {
            $this->setPrecioUnitarioDolares( $o_ALM_TransferenciaDetalleBN->getPrecioUnitarioDolares() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getMontoTotalDolares() ) )
        {
            $this->setMontoTotalDolares( $o_ALM_TransferenciaDetalleBN->getMontoTotalDolares() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_TransferenciaDetalleBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getObservaciones() ) )
        {
            $this->setObservaciones( $o_ALM_TransferenciaDetalleBN->getObservaciones() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_TransferenciaDetalleBN->getEstado() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TransferenciaDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TransferenciaDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TransferenciaDetalleBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TransferenciaDetalleBN->getFechaModificacion() );
        }
    }

    /**
    * @return ALM_TransferenciaDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTransferencia, $i_IdSecuencia )
    {
        if( is_null( $i_IdTransferencia ) ){ $i_IdTransferencia = -1; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransferenciaDetalle ";
        $s_SQLQuery .= "WHERE IdTransferencia = ".$i_IdTransferencia." ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_TransferenciaDetalleBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_TransferenciaDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_TransferenciaDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTransferencia() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.IdTransferencia = ".$this->getIdTransferencia()." AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getDescripcionItem() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.DescripcionItem = '".$this->getDescripcionItem()."' AND ";
        if ( !is_null( $this->getUnidadCodigo() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.UnidadCodigo = '".$this->getUnidadCodigo()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getCantidadRecepcionada() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.CantidadRecepcionada = ".$this->getCantidadRecepcionada()." AND ";
        if ( !is_null( $this->getCantidadDoble() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.CantidadDoble = ".$this->getCantidadDoble()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getPrecioUnitarioDolares() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.PrecioUnitarioDolares = ".$this->getPrecioUnitarioDolares()." AND ";
        if ( !is_null( $this->getMontoTotalDolares() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.MontoTotalDolares = ".$this->getMontoTotalDolares()." AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getObservaciones() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.Observaciones = '".$this->getObservaciones()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_TransferenciaDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_TransferenciaDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_TransferenciaDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransferenciaDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_TransferenciaDetalleBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_TransferenciaDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_TransferenciaDetalleBN[] = $o_ALM_TransferenciaDetalleBN;
            }
        }
        return $a_ALM_TransferenciaDetalleBN;
    }

    /* Devuelve un objeto ALM_TransferenciaDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_TransferenciaDetalle )
    {
        $o_ALM_TransferenciaDetalleBN = new ALM_TransferenciaDetalleBN();
        if ( !is_null( $a_ALM_TransferenciaDetalle['IdTransferencia'] ) ) $o_ALM_TransferenciaDetalleBN->setIdTransferencia( ( integer ) $a_ALM_TransferenciaDetalle['IdTransferencia'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['IdSecuencia'] ) ) $o_ALM_TransferenciaDetalleBN->setIdSecuencia( ( integer ) $a_ALM_TransferenciaDetalle['IdSecuencia'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['IdItem'] ) ) $o_ALM_TransferenciaDetalleBN->setIdItem( $a_ALM_TransferenciaDetalle['IdItem'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['IdLote'] ) ) $o_ALM_TransferenciaDetalleBN->setIdLote( $a_ALM_TransferenciaDetalle['IdLote'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['DescripcionItem'] ) ) $o_ALM_TransferenciaDetalleBN->setDescripcionItem( $a_ALM_TransferenciaDetalle['DescripcionItem'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['UnidadCodigo'] ) ) $o_ALM_TransferenciaDetalleBN->setUnidadCodigo( $a_ALM_TransferenciaDetalle['UnidadCodigo'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['Cantidad'] ) ) $o_ALM_TransferenciaDetalleBN->setCantidad( ( float ) $a_ALM_TransferenciaDetalle['Cantidad'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['CantidadRecepcionada'] ) ) $o_ALM_TransferenciaDetalleBN->setCantidadRecepcionada( ( float ) $a_ALM_TransferenciaDetalle['CantidadRecepcionada'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['CantidadDoble'] ) ) $o_ALM_TransferenciaDetalleBN->setCantidadDoble( ( float ) $a_ALM_TransferenciaDetalle['CantidadDoble'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['PrecioUnitario'] ) ) $o_ALM_TransferenciaDetalleBN->setPrecioUnitario( ( float ) $a_ALM_TransferenciaDetalle['PrecioUnitario'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['MontoTotal'] ) ) $o_ALM_TransferenciaDetalleBN->setMontoTotal( ( float ) $a_ALM_TransferenciaDetalle['MontoTotal'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['PrecioUnitarioDolares'] ) ) $o_ALM_TransferenciaDetalleBN->setPrecioUnitarioDolares( ( float ) $a_ALM_TransferenciaDetalle['PrecioUnitarioDolares'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['MontoTotalDolares'] ) ) $o_ALM_TransferenciaDetalleBN->setMontoTotalDolares( ( float ) $a_ALM_TransferenciaDetalle['MontoTotalDolares'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['FechaVencimiento'] ) ) $o_ALM_TransferenciaDetalleBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_ALM_TransferenciaDetalle['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_TransferenciaDetalle['Observaciones'] ) ) $o_ALM_TransferenciaDetalleBN->setObservaciones( $a_ALM_TransferenciaDetalle['Observaciones'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['Estado'] ) ) $o_ALM_TransferenciaDetalleBN->setEstado( $a_ALM_TransferenciaDetalle['Estado'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['UsuarioCreacion'] ) ) $o_ALM_TransferenciaDetalleBN->setUsuarioCreacion( $a_ALM_TransferenciaDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['FechaCreacion'] ) ) $o_ALM_TransferenciaDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_TransferenciaDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransferenciaDetalle['UsuarioModificacion'] ) ) $o_ALM_TransferenciaDetalleBN->setUsuarioModificacion( $a_ALM_TransferenciaDetalle['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_TransferenciaDetalle['FechaModificacion'] ) ) $o_ALM_TransferenciaDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_TransferenciaDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_TransferenciaDetalleBN;
    }
}
?>