<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransferenciaCabecera.xml */
/* Generado: 2022-04-18 21:14:52 */

/* Busqueda de registros de la tabla ALM_TransferenciaCabecera. */
abstract class BaseALM_TransferenciaCabeceraFN extends ALM_TransferenciaCabeceraBN
{
    /* Declaracion de constantes */
    const IdTransferencia = "ALM_TransferenciaCabecera.IdTransferencia";
    const IdCompania = "ALM_TransferenciaCabecera.IdCompania";
    const IdSucursal = "ALM_TransferenciaCabecera.IdSucursal";
    const IdTipoDocumento = "ALM_TransferenciaCabecera.IdTipoDocumento";
    const IdNumeroDocumento = "ALM_TransferenciaCabecera.IdNumeroDocumento";
    const IdTransaccion = "ALM_TransferenciaCabecera.IdTransaccion";
    const IdAlmacen = "ALM_TransferenciaCabecera.IdAlmacen";
    const AlmacenTraslado = "ALM_TransferenciaCabecera.AlmacenTraslado";
    const IdTransaccionOperacion = "ALM_TransferenciaCabecera.IdTransaccionOperacion";
    const FechaDocumento = "ALM_TransferenciaCabecera.FechaDocumento";
    const TipodeCambio = "ALM_TransferenciaCabecera.TipodeCambio";
    const Periodo = "ALM_TransferenciaCabecera.Periodo";
    const PeriodoAnulacion = "ALM_TransferenciaCabecera.PeriodoAnulacion";
    const Voucher = "ALM_TransferenciaCabecera.Voucher";
    const CentroCostoConsumo = "ALM_TransferenciaCabecera.CentroCostoConsumo";
    const ImprimirGuia = "ALM_TransferenciaCabecera.ImprimirGuia";
    const ReferenciaTipoDocumento = "ALM_TransferenciaCabecera.ReferenciaTipoDocumento";
    const ReferenciaSerieDocumento = "ALM_TransferenciaCabecera.ReferenciaSerieDocumento";
    const ReferenciaNumeroDocumento = "ALM_TransferenciaCabecera.ReferenciaNumeroDocumento";
    const GuiaProveedor = "ALM_TransferenciaCabecera.GuiaProveedor";
    const IdOrdenProd = "ALM_TransferenciaCabecera.IdOrdenProd";
    const IdProyecto = "ALM_TransferenciaCabecera.IdProyecto";
    const ReferenciaNumeroInterno = "ALM_TransferenciaCabecera.ReferenciaNumeroInterno";
    const ReferenciaInterno = "ALM_TransferenciaCabecera.ReferenciaInterno";
    const IdChofer = "ALM_TransferenciaCabecera.IdChofer";
    const IdVehiculo = "ALM_TransferenciaCabecera.IdVehiculo";
    const Transportista = "ALM_TransferenciaCabecera.Transportista";
    const VehiculoMarca = "ALM_TransferenciaCabecera.VehiculoMarca";
    const VehiculoPlaca = "ALM_TransferenciaCabecera.VehiculoPlaca";
    const LicenciaConducir = "ALM_TransferenciaCabecera.LicenciaConducir";
    const ResponsableTraslado = "ALM_TransferenciaCabecera.ResponsableTraslado";
    const MotivoDevolucion = "ALM_TransferenciaCabecera.MotivoDevolucion";
    const UnidadNegocio = "ALM_TransferenciaCabecera.UnidadNegocio";
    const Estado = "ALM_TransferenciaCabecera.Estado";
    const UsuarioModificacion = "ALM_TransferenciaCabecera.UsuarioModificacion";
    const FechaModificacion = "ALM_TransferenciaCabecera.FechaModificacion";
    const UsuarioCreacion = "ALM_TransferenciaCabecera.UsuarioCreacion";
    const FechaCreacion = "ALM_TransferenciaCabecera.FechaCreacion";
    const CompaniaDescripcion = "ALM_TransferenciaCabecera.CompaniaDescripcion";
    const Comentario = "ALM_TransferenciaCabecera.Comentario";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_TransferenciaCabecera.IdTransferencia AS IdTransferencia, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdTransaccion AS IdTransaccion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.AlmacenTraslado AS AlmacenTraslado, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdTransaccionOperacion AS IdTransaccionOperacion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.FechaDocumento AS FechaDocumento, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.TipodeCambio AS TipodeCambio, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.Periodo AS Periodo, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.PeriodoAnulacion AS PeriodoAnulacion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.Voucher AS Voucher, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.CentroCostoConsumo AS CentroCostoConsumo, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.ImprimirGuia AS ImprimirGuia, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaTipoDocumento AS ReferenciaTipoDocumento, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaSerieDocumento AS ReferenciaSerieDocumento, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaNumeroDocumento AS ReferenciaNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.GuiaProveedor AS GuiaProveedor, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdOrdenProd AS IdOrdenProd, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaNumeroInterno AS ReferenciaNumeroInterno, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaInterno AS ReferenciaInterno, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdChofer AS IdChofer, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.IdVehiculo AS IdVehiculo, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.Transportista AS Transportista, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.VehiculoMarca AS VehiculoMarca, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.VehiculoPlaca AS VehiculoPlaca, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.LicenciaConducir AS LicenciaConducir, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.ResponsableTraslado AS ResponsableTraslado, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.MotivoDevolucion AS MotivoDevolucion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.UnidadNegocio AS UnidadNegocio, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.CompaniaDescripcion AS CompaniaDescripcion, ";
        $s_SQLQuery .= "ALM_TransferenciaCabecera.Comentario AS Comentario ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_TransferenciaCabeceraBN */
    public function setByBN( ALM_TransferenciaCabeceraBN $o_ALM_TransferenciaCabeceraBN )
    {
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdTransferencia() ) )
        {
            $this->setIdTransferencia( $o_ALM_TransferenciaCabeceraBN->getIdTransferencia() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_TransferenciaCabeceraBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_TransferenciaCabeceraBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_ALM_TransferenciaCabeceraBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_ALM_TransferenciaCabeceraBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_ALM_TransferenciaCabeceraBN->getIdTransaccion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_TransferenciaCabeceraBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getAlmacenTraslado() ) )
        {
            $this->setAlmacenTraslado( $o_ALM_TransferenciaCabeceraBN->getAlmacenTraslado() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdTransaccionOperacion() ) )
        {
            $this->setIdTransaccionOperacion( $o_ALM_TransferenciaCabeceraBN->getIdTransaccionOperacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getFechaDocumento() ) )
        {
            $this->setFechaDocumento( $o_ALM_TransferenciaCabeceraBN->getFechaDocumento() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getTipodeCambio() ) )
        {
            $this->setTipodeCambio( $o_ALM_TransferenciaCabeceraBN->getTipodeCambio() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_ALM_TransferenciaCabeceraBN->getPeriodo() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getPeriodoAnulacion() ) )
        {
            $this->setPeriodoAnulacion( $o_ALM_TransferenciaCabeceraBN->getPeriodoAnulacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getVoucher() ) )
        {
            $this->setVoucher( $o_ALM_TransferenciaCabeceraBN->getVoucher() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getCentroCostoConsumo() ) )
        {
            $this->setCentroCostoConsumo( $o_ALM_TransferenciaCabeceraBN->getCentroCostoConsumo() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getImprimirGuia() ) )
        {
            $this->setImprimirGuia( $o_ALM_TransferenciaCabeceraBN->getImprimirGuia() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getReferenciaTipoDocumento() ) )
        {
            $this->setReferenciaTipoDocumento( $o_ALM_TransferenciaCabeceraBN->getReferenciaTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getReferenciaSerieDocumento() ) )
        {
            $this->setReferenciaSerieDocumento( $o_ALM_TransferenciaCabeceraBN->getReferenciaSerieDocumento() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_ALM_TransferenciaCabeceraBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getGuiaProveedor() ) )
        {
            $this->setGuiaProveedor( $o_ALM_TransferenciaCabeceraBN->getGuiaProveedor() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdOrdenProd() ) )
        {
            $this->setIdOrdenProd( $o_ALM_TransferenciaCabeceraBN->getIdOrdenProd() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_ALM_TransferenciaCabeceraBN->getIdProyecto() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getReferenciaNumeroInterno() ) )
        {
            $this->setReferenciaNumeroInterno( $o_ALM_TransferenciaCabeceraBN->getReferenciaNumeroInterno() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getReferenciaInterno() ) )
        {
            $this->setReferenciaInterno( $o_ALM_TransferenciaCabeceraBN->getReferenciaInterno() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdChofer() ) )
        {
            $this->setIdChofer( $o_ALM_TransferenciaCabeceraBN->getIdChofer() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getIdVehiculo() ) )
        {
            $this->setIdVehiculo( $o_ALM_TransferenciaCabeceraBN->getIdVehiculo() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getTransportista() ) )
        {
            $this->setTransportista( $o_ALM_TransferenciaCabeceraBN->getTransportista() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getVehiculoMarca() ) )
        {
            $this->setVehiculoMarca( $o_ALM_TransferenciaCabeceraBN->getVehiculoMarca() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getVehiculoPlaca() ) )
        {
            $this->setVehiculoPlaca( $o_ALM_TransferenciaCabeceraBN->getVehiculoPlaca() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getLicenciaConducir() ) )
        {
            $this->setLicenciaConducir( $o_ALM_TransferenciaCabeceraBN->getLicenciaConducir() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getResponsableTraslado() ) )
        {
            $this->setResponsableTraslado( $o_ALM_TransferenciaCabeceraBN->getResponsableTraslado() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getMotivoDevolucion() ) )
        {
            $this->setMotivoDevolucion( $o_ALM_TransferenciaCabeceraBN->getMotivoDevolucion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getUnidadNegocio() ) )
        {
            $this->setUnidadNegocio( $o_ALM_TransferenciaCabeceraBN->getUnidadNegocio() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_TransferenciaCabeceraBN->getEstado() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TransferenciaCabeceraBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TransferenciaCabeceraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TransferenciaCabeceraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TransferenciaCabeceraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getCompaniaDescripcion() ) )
        {
            $this->setCompaniaDescripcion( $o_ALM_TransferenciaCabeceraBN->getCompaniaDescripcion() );
        }
        if ( !is_null( $o_ALM_TransferenciaCabeceraBN->getComentario() ) )
        {
            $this->setComentario( $o_ALM_TransferenciaCabeceraBN->getComentario() );
        }
    }

    /**
    * @return ALM_TransferenciaCabeceraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTransferencia )
    {
        if( is_null( $i_IdTransferencia ) ){ $i_IdTransferencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransferenciaCabecera ";
        $s_SQLQuery .= "WHERE IdTransferencia = ".$i_IdTransferencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_TransferenciaCabeceraBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_TransferenciaCabeceraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_TransferenciaCabeceraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTransferencia() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdTransferencia = ".$this->getIdTransferencia()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdTransaccion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdTransaccion = '".$this->getIdTransaccion()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getAlmacenTraslado() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.AlmacenTraslado = '".$this->getAlmacenTraslado()."' AND ";
        if ( !is_null( $this->getIdTransaccionOperacion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdTransaccionOperacion = '".$this->getIdTransaccionOperacion()."' AND ";
        if ( !is_null( $this->getFechaDocumento() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.FechaDocumento = '".$this->getFechaDocumento()."' AND ";
        if ( !is_null( $this->getTipodeCambio() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.TipodeCambio = ".$this->getTipodeCambio()." AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getPeriodoAnulacion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.PeriodoAnulacion = '".$this->getPeriodoAnulacion()."' AND ";
        if ( !is_null( $this->getVoucher() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.Voucher = '".$this->getVoucher()."' AND ";
        if ( !is_null( $this->getCentroCostoConsumo() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.CentroCostoConsumo = '".$this->getCentroCostoConsumo()."' AND ";
        if ( !is_null( $this->getImprimirGuia() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.ImprimirGuia = '".$this->getImprimirGuia()."' AND ";
        if ( !is_null( $this->getReferenciaTipoDocumento() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaTipoDocumento = '".$this->getReferenciaTipoDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaSerieDocumento() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaSerieDocumento = '".$this->getReferenciaSerieDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."' AND ";
        if ( !is_null( $this->getGuiaProveedor() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.GuiaProveedor = '".$this->getGuiaProveedor()."' AND ";
        if ( !is_null( $this->getIdOrdenProd() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdOrdenProd = ".$this->getIdOrdenProd()." AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getReferenciaNumeroInterno() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaNumeroInterno = ".$this->getReferenciaNumeroInterno()." AND ";
        if ( !is_null( $this->getReferenciaInterno() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.ReferenciaInterno = '".$this->getReferenciaInterno()."' AND ";
        if ( !is_null( $this->getIdChofer() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdChofer = ".$this->getIdChofer()." AND ";
        if ( !is_null( $this->getIdVehiculo() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.IdVehiculo = ".$this->getIdVehiculo()." AND ";
        if ( !is_null( $this->getTransportista() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.Transportista = ".$this->getTransportista()." AND ";
        if ( !is_null( $this->getVehiculoMarca() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.VehiculoMarca = '".$this->getVehiculoMarca()."' AND ";
        if ( !is_null( $this->getVehiculoPlaca() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.VehiculoPlaca = '".$this->getVehiculoPlaca()."' AND ";
        if ( !is_null( $this->getLicenciaConducir() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.LicenciaConducir = '".$this->getLicenciaConducir()."' AND ";
        if ( !is_null( $this->getResponsableTraslado() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.ResponsableTraslado = '".$this->getResponsableTraslado()."' AND ";
        if ( !is_null( $this->getMotivoDevolucion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.MotivoDevolucion = '".$this->getMotivoDevolucion()."' AND ";
        if ( !is_null( $this->getUnidadNegocio() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.UnidadNegocio = '".$this->getUnidadNegocio()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getCompaniaDescripcion() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.CompaniaDescripcion = '".$this->getCompaniaDescripcion()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "ALM_TransferenciaCabecera.Comentario = '".$this->getComentario()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_TransferenciaCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_TransferenciaCabeceraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransferenciaCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_TransferenciaCabeceraBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_TransferenciaCabeceraBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_TransferenciaCabeceraBN[] = $o_ALM_TransferenciaCabeceraBN;
            }
        }
        return $a_ALM_TransferenciaCabeceraBN;
    }

    /* Devuelve un objeto ALM_TransferenciaCabeceraBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_TransferenciaCabecera )
    {
        $o_ALM_TransferenciaCabeceraBN = new ALM_TransferenciaCabeceraBN();
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdTransferencia'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdTransferencia( ( integer ) $a_ALM_TransferenciaCabecera['IdTransferencia'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdCompania'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdCompania( ( integer ) $a_ALM_TransferenciaCabecera['IdCompania'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdSucursal'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdSucursal( ( integer ) $a_ALM_TransferenciaCabecera['IdSucursal'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdTipoDocumento'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdTipoDocumento( $a_ALM_TransferenciaCabecera['IdTipoDocumento'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdNumeroDocumento'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdNumeroDocumento( $a_ALM_TransferenciaCabecera['IdNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdTransaccion'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdTransaccion( $a_ALM_TransferenciaCabecera['IdTransaccion'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdAlmacen'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdAlmacen( $a_ALM_TransferenciaCabecera['IdAlmacen'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['AlmacenTraslado'] ) ) $o_ALM_TransferenciaCabeceraBN->setAlmacenTraslado( $a_ALM_TransferenciaCabecera['AlmacenTraslado'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdTransaccionOperacion'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdTransaccionOperacion( $a_ALM_TransferenciaCabecera['IdTransaccionOperacion'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['FechaDocumento'] ) ) $o_ALM_TransferenciaCabeceraBN->setFechaDocumento( utilTimestamp::getTimestamp( $a_ALM_TransferenciaCabecera['FechaDocumento'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_TransferenciaCabecera['TipodeCambio'] ) ) $o_ALM_TransferenciaCabeceraBN->setTipodeCambio( ( float ) $a_ALM_TransferenciaCabecera['TipodeCambio'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['Periodo'] ) ) $o_ALM_TransferenciaCabeceraBN->setPeriodo( $a_ALM_TransferenciaCabecera['Periodo'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['PeriodoAnulacion'] ) ) $o_ALM_TransferenciaCabeceraBN->setPeriodoAnulacion( $a_ALM_TransferenciaCabecera['PeriodoAnulacion'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['Voucher'] ) ) $o_ALM_TransferenciaCabeceraBN->setVoucher( $a_ALM_TransferenciaCabecera['Voucher'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['CentroCostoConsumo'] ) ) $o_ALM_TransferenciaCabeceraBN->setCentroCostoConsumo( $a_ALM_TransferenciaCabecera['CentroCostoConsumo'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['ImprimirGuia'] ) ) $o_ALM_TransferenciaCabeceraBN->setImprimirGuia( $a_ALM_TransferenciaCabecera['ImprimirGuia'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['ReferenciaTipoDocumento'] ) ) $o_ALM_TransferenciaCabeceraBN->setReferenciaTipoDocumento( $a_ALM_TransferenciaCabecera['ReferenciaTipoDocumento'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['ReferenciaSerieDocumento'] ) ) $o_ALM_TransferenciaCabeceraBN->setReferenciaSerieDocumento( $a_ALM_TransferenciaCabecera['ReferenciaSerieDocumento'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['ReferenciaNumeroDocumento'] ) ) $o_ALM_TransferenciaCabeceraBN->setReferenciaNumeroDocumento( $a_ALM_TransferenciaCabecera['ReferenciaNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['GuiaProveedor'] ) ) $o_ALM_TransferenciaCabeceraBN->setGuiaProveedor( $a_ALM_TransferenciaCabecera['GuiaProveedor'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdOrdenProd'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdOrdenProd( ( integer ) $a_ALM_TransferenciaCabecera['IdOrdenProd'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdProyecto'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdProyecto( ( integer ) $a_ALM_TransferenciaCabecera['IdProyecto'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['ReferenciaNumeroInterno'] ) ) $o_ALM_TransferenciaCabeceraBN->setReferenciaNumeroInterno( ( integer ) $a_ALM_TransferenciaCabecera['ReferenciaNumeroInterno'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['ReferenciaInterno'] ) ) $o_ALM_TransferenciaCabeceraBN->setReferenciaInterno( $a_ALM_TransferenciaCabecera['ReferenciaInterno'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdChofer'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdChofer( ( integer ) $a_ALM_TransferenciaCabecera['IdChofer'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['IdVehiculo'] ) ) $o_ALM_TransferenciaCabeceraBN->setIdVehiculo( ( integer ) $a_ALM_TransferenciaCabecera['IdVehiculo'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['Transportista'] ) ) $o_ALM_TransferenciaCabeceraBN->setTransportista( ( integer ) $a_ALM_TransferenciaCabecera['Transportista'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['VehiculoMarca'] ) ) $o_ALM_TransferenciaCabeceraBN->setVehiculoMarca( $a_ALM_TransferenciaCabecera['VehiculoMarca'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['VehiculoPlaca'] ) ) $o_ALM_TransferenciaCabeceraBN->setVehiculoPlaca( $a_ALM_TransferenciaCabecera['VehiculoPlaca'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['LicenciaConducir'] ) ) $o_ALM_TransferenciaCabeceraBN->setLicenciaConducir( $a_ALM_TransferenciaCabecera['LicenciaConducir'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['ResponsableTraslado'] ) ) $o_ALM_TransferenciaCabeceraBN->setResponsableTraslado( $a_ALM_TransferenciaCabecera['ResponsableTraslado'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['MotivoDevolucion'] ) ) $o_ALM_TransferenciaCabeceraBN->setMotivoDevolucion( $a_ALM_TransferenciaCabecera['MotivoDevolucion'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['UnidadNegocio'] ) ) $o_ALM_TransferenciaCabeceraBN->setUnidadNegocio( $a_ALM_TransferenciaCabecera['UnidadNegocio'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['Estado'] ) ) $o_ALM_TransferenciaCabeceraBN->setEstado( $a_ALM_TransferenciaCabecera['Estado'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['UsuarioModificacion'] ) ) $o_ALM_TransferenciaCabeceraBN->setUsuarioModificacion( $a_ALM_TransferenciaCabecera['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['FechaModificacion'] ) ) $o_ALM_TransferenciaCabeceraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_TransferenciaCabecera['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransferenciaCabecera['UsuarioCreacion'] ) ) $o_ALM_TransferenciaCabeceraBN->setUsuarioCreacion( $a_ALM_TransferenciaCabecera['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['FechaCreacion'] ) ) $o_ALM_TransferenciaCabeceraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_TransferenciaCabecera['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransferenciaCabecera['CompaniaDescripcion'] ) ) $o_ALM_TransferenciaCabeceraBN->setCompaniaDescripcion( $a_ALM_TransferenciaCabecera['CompaniaDescripcion'] );
        if ( !is_null( $a_ALM_TransferenciaCabecera['Comentario'] ) ) $o_ALM_TransferenciaCabeceraBN->setComentario( $a_ALM_TransferenciaCabecera['Comentario'] );
        return $o_ALM_TransferenciaCabeceraBN;
    }
}
?>