<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TipoDocumento.xml */
/* Generado: 2022-04-18 21:14:51 */

/* Busqueda de registros de la tabla ALM_TipoDocumento. */
abstract class BaseALM_TipoDocumentoFN extends ALM_TipoDocumentoBN
{
    /* Declaracion de constantes */
    const IdTipoDocumento = "ALM_TipoDocumento.IdTipoDocumento";
    const CodigoSunat = "ALM_TipoDocumento.CodigoSunat";
    const Descripcion = "ALM_TipoDocumento.Descripcion";
    const EsFiscalFlag = "ALM_TipoDocumento.EsFiscalFlag";
    const TransaccionSistemaFlag = "ALM_TipoDocumento.TransaccionSistemaFlag";
    const Estado = "ALM_TipoDocumento.Estado";
    const UsuarioCreacion = "ALM_TipoDocumento.UsuarioCreacion";
    const FechaModificacion = "ALM_TipoDocumento.FechaModificacion";
    const FechaCreacion = "ALM_TipoDocumento.FechaCreacion";
    const UsuarioModificacion = "ALM_TipoDocumento.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_TipoDocumento.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "ALM_TipoDocumento.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "ALM_TipoDocumento.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "ALM_TipoDocumento.EsFiscalFlag AS EsFiscalFlag, ";
        $s_SQLQuery .= "ALM_TipoDocumento.TransaccionSistemaFlag AS TransaccionSistemaFlag, ";
        $s_SQLQuery .= "ALM_TipoDocumento.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_TipoDocumento.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_TipoDocumento.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_TipoDocumento.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_TipoDocumento.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_TipoDocumentoBN */
    public function setByBN( ALM_TipoDocumentoBN $o_ALM_TipoDocumentoBN )
    {
        if ( !is_null( $o_ALM_TipoDocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_ALM_TipoDocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_ALM_TipoDocumentoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_TipoDocumentoBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getEsFiscalFlag() ) )
        {
            $this->setEsFiscalFlag( $o_ALM_TipoDocumentoBN->getEsFiscalFlag() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getTransaccionSistemaFlag() ) )
        {
            $this->setTransaccionSistemaFlag( $o_ALM_TipoDocumentoBN->getTransaccionSistemaFlag() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_TipoDocumentoBN->getEstado() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TipoDocumentoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TipoDocumentoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TipoDocumentoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TipoDocumentoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_TipoDocumentoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdTipoDocumento )
    {
        if( is_null( $s_IdTipoDocumento ) ){ $s_IdTipoDocumento = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TipoDocumento ";
        $s_SQLQuery .= "WHERE IdTipoDocumento = '".$s_IdTipoDocumento."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_TipoDocumentoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_TipoDocumentoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_TipoDocumentoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "ALM_TipoDocumento.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "ALM_TipoDocumento.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "ALM_TipoDocumento.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEsFiscalFlag() ) ) $s_SQLQuery .= "ALM_TipoDocumento.EsFiscalFlag = '".$this->getEsFiscalFlag()."' AND ";
        if ( !is_null( $this->getTransaccionSistemaFlag() ) ) $s_SQLQuery .= "ALM_TipoDocumento.TransaccionSistemaFlag = '".$this->getTransaccionSistemaFlag()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_TipoDocumento.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_TipoDocumento.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_TipoDocumento.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_TipoDocumento.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_TipoDocumento.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_TipoDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_TipoDocumentoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TipoDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_TipoDocumentoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_TipoDocumentoBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_TipoDocumentoBN[] = $o_ALM_TipoDocumentoBN;
            }
        }
        return $a_ALM_TipoDocumentoBN;
    }

    /* Devuelve un objeto ALM_TipoDocumentoBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_TipoDocumento )
    {
        $o_ALM_TipoDocumentoBN = new ALM_TipoDocumentoBN();
        if ( !is_null( $a_ALM_TipoDocumento['IdTipoDocumento'] ) ) $o_ALM_TipoDocumentoBN->setIdTipoDocumento( $a_ALM_TipoDocumento['IdTipoDocumento'] );
        if ( !is_null( $a_ALM_TipoDocumento['CodigoSunat'] ) ) $o_ALM_TipoDocumentoBN->setCodigoSunat( $a_ALM_TipoDocumento['CodigoSunat'] );
        if ( !is_null( $a_ALM_TipoDocumento['Descripcion'] ) ) $o_ALM_TipoDocumentoBN->setDescripcion( $a_ALM_TipoDocumento['Descripcion'] );
        if ( !is_null( $a_ALM_TipoDocumento['EsFiscalFlag'] ) ) $o_ALM_TipoDocumentoBN->setEsFiscalFlag( $a_ALM_TipoDocumento['EsFiscalFlag'] );
        if ( !is_null( $a_ALM_TipoDocumento['TransaccionSistemaFlag'] ) ) $o_ALM_TipoDocumentoBN->setTransaccionSistemaFlag( $a_ALM_TipoDocumento['TransaccionSistemaFlag'] );
        if ( !is_null( $a_ALM_TipoDocumento['Estado'] ) ) $o_ALM_TipoDocumentoBN->setEstado( $a_ALM_TipoDocumento['Estado'] );
        if ( !is_null( $a_ALM_TipoDocumento['UsuarioCreacion'] ) ) $o_ALM_TipoDocumentoBN->setUsuarioCreacion( $a_ALM_TipoDocumento['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_TipoDocumento['FechaModificacion'] ) ) $o_ALM_TipoDocumentoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_TipoDocumento['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TipoDocumento['FechaCreacion'] ) ) $o_ALM_TipoDocumentoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_TipoDocumento['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TipoDocumento['UsuarioModificacion'] ) ) $o_ALM_TipoDocumentoBN->setUsuarioModificacion( $a_ALM_TipoDocumento['UsuarioModificacion'] );
        return $o_ALM_TipoDocumentoBN;
    }
}
?>