<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_RequerimientoDetalle.xml */
/* Generado: 2022-04-18 21:14:51 */

/* Busqueda de registros de la tabla ALM_RequerimientoDetalle. */
abstract class BaseALM_RequerimientoDetalleFN extends ALM_RequerimientoDetalleBN
{
    /* Declaracion de constantes */
    const IdRequerimientoDetalle = "ALM_RequerimientoDetalle.IdRequerimientoDetalle";
    const IdRequerimiento = "ALM_RequerimientoDetalle.IdRequerimiento";
    const IdItem = "ALM_RequerimientoDetalle.IdItem";
    const CantidadSugerida = "ALM_RequerimientoDetalle.CantidadSugerida";
    const CantidadPedida = "ALM_RequerimientoDetalle.CantidadPedida";
    const IdMoneda = "ALM_RequerimientoDetalle.IdMoneda";
    const IdLote = "ALM_RequerimientoDetalle.IdLote";
    const FechaVencimiento = "ALM_RequerimientoDetalle.FechaVencimiento";
    const StockMinimo = "ALM_RequerimientoDetalle.StockMinimo";
    const StockMaximo = "ALM_RequerimientoDetalle.StockMaximo";
    const PrecioUnitario = "ALM_RequerimientoDetalle.PrecioUnitario";
    const PrecioUnitarioIGV = "ALM_RequerimientoDetalle.PrecioUnitarioIGV";
    const PrecioSubTotal = "ALM_RequerimientoDetalle.PrecioSubTotal";
    const ValorIGV = "ALM_RequerimientoDetalle.ValorIGV";
    const PrecioTotalConIGV = "ALM_RequerimientoDetalle.PrecioTotalConIGV";
    const Estado = "ALM_RequerimientoDetalle.Estado";
    const IGVExoneradoFlag = "ALM_RequerimientoDetalle.IGVExoneradoFlag";
    const FechaCreacion = "ALM_RequerimientoDetalle.FechaCreacion";
    const UsuarioCreacion = "ALM_RequerimientoDetalle.UsuarioCreacion";
    const UsuarioModificacion = "ALM_RequerimientoDetalle.UsuarioModificacion";
    const FechaModificacion = "ALM_RequerimientoDetalle.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_RequerimientoDetalle.IdRequerimientoDetalle AS IdRequerimientoDetalle, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.IdRequerimiento AS IdRequerimiento, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.CantidadSugerida AS CantidadSugerida, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.CantidadPedida AS CantidadPedida, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.StockMinimo AS StockMinimo, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.StockMaximo AS StockMaximo, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioUnitarioIGV AS PrecioUnitarioIGV, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioSubTotal AS PrecioSubTotal, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.ValorIGV AS ValorIGV, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioTotalConIGV AS PrecioTotalConIGV, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.IGVExoneradoFlag AS IGVExoneradoFlag, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalle.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_RequerimientoDetalleBN */
    public function setByBN( ALM_RequerimientoDetalleBN $o_ALM_RequerimientoDetalleBN )
    {
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle() ) )
        {
            $this->setIdRequerimientoDetalle( $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getIdRequerimiento() ) )
        {
            $this->setIdRequerimiento( $o_ALM_RequerimientoDetalleBN->getIdRequerimiento() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_RequerimientoDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getCantidadSugerida() ) )
        {
            $this->setCantidadSugerida( $o_ALM_RequerimientoDetalleBN->getCantidadSugerida() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getCantidadPedida() ) )
        {
            $this->setCantidadPedida( $o_ALM_RequerimientoDetalleBN->getCantidadPedida() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_ALM_RequerimientoDetalleBN->getIdMoneda() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_RequerimientoDetalleBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_RequerimientoDetalleBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getStockMinimo() ) )
        {
            $this->setStockMinimo( $o_ALM_RequerimientoDetalleBN->getStockMinimo() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getStockMaximo() ) )
        {
            $this->setStockMaximo( $o_ALM_RequerimientoDetalleBN->getStockMaximo() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_ALM_RequerimientoDetalleBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getPrecioUnitarioIGV() ) )
        {
            $this->setPrecioUnitarioIGV( $o_ALM_RequerimientoDetalleBN->getPrecioUnitarioIGV() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getPrecioSubTotal() ) )
        {
            $this->setPrecioSubTotal( $o_ALM_RequerimientoDetalleBN->getPrecioSubTotal() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getValorIGV() ) )
        {
            $this->setValorIGV( $o_ALM_RequerimientoDetalleBN->getValorIGV() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getPrecioTotalConIGV() ) )
        {
            $this->setPrecioTotalConIGV( $o_ALM_RequerimientoDetalleBN->getPrecioTotalConIGV() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_RequerimientoDetalleBN->getEstado() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getIGVExoneradoFlag() ) )
        {
            $this->setIGVExoneradoFlag( $o_ALM_RequerimientoDetalleBN->getIGVExoneradoFlag() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_RequerimientoDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_RequerimientoDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_RequerimientoDetalleBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_RequerimientoDetalleBN->getFechaModificacion() );
        }
    }

    /**
    * @return ALM_RequerimientoDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdRequerimientoDetalle )
    {
        if( is_null( $i_IdRequerimientoDetalle ) ){ $i_IdRequerimientoDetalle = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_RequerimientoDetalle ";
        $s_SQLQuery .= "WHERE IdRequerimientoDetalle = ".$i_IdRequerimientoDetalle." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_RequerimientoDetalleBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_RequerimientoDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_RequerimientoDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRequerimientoDetalle() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.IdRequerimientoDetalle = ".$this->getIdRequerimientoDetalle()." AND ";
        if ( !is_null( $this->getIdRequerimiento() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.IdRequerimiento = ".$this->getIdRequerimiento()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getCantidadSugerida() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.CantidadSugerida = ".$this->getCantidadSugerida()." AND ";
        if ( !is_null( $this->getCantidadPedida() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.CantidadPedida = ".$this->getCantidadPedida()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getStockMinimo() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.StockMinimo = ".$this->getStockMinimo()." AND ";
        if ( !is_null( $this->getStockMaximo() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.StockMaximo = ".$this->getStockMaximo()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getPrecioUnitarioIGV() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioUnitarioIGV = ".$this->getPrecioUnitarioIGV()." AND ";
        if ( !is_null( $this->getPrecioSubTotal() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioSubTotal = ".$this->getPrecioSubTotal()." AND ";
        if ( !is_null( $this->getValorIGV() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.ValorIGV = ".$this->getValorIGV()." AND ";
        if ( !is_null( $this->getPrecioTotalConIGV() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.PrecioTotalConIGV = ".$this->getPrecioTotalConIGV()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getIGVExoneradoFlag() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.IGVExoneradoFlag = '".$this->getIGVExoneradoFlag()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_RequerimientoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_RequerimientoDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_RequerimientoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_RequerimientoDetalleBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_RequerimientoDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_RequerimientoDetalleBN[] = $o_ALM_RequerimientoDetalleBN;
            }
        }
        return $a_ALM_RequerimientoDetalleBN;
    }

    /* Devuelve un objeto ALM_RequerimientoDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_RequerimientoDetalle )
    {
        $o_ALM_RequerimientoDetalleBN = new ALM_RequerimientoDetalleBN();
        if ( !is_null( $a_ALM_RequerimientoDetalle['IdRequerimientoDetalle'] ) ) $o_ALM_RequerimientoDetalleBN->setIdRequerimientoDetalle( ( integer ) $a_ALM_RequerimientoDetalle['IdRequerimientoDetalle'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['IdRequerimiento'] ) ) $o_ALM_RequerimientoDetalleBN->setIdRequerimiento( ( integer ) $a_ALM_RequerimientoDetalle['IdRequerimiento'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['IdItem'] ) ) $o_ALM_RequerimientoDetalleBN->setIdItem( $a_ALM_RequerimientoDetalle['IdItem'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['CantidadSugerida'] ) ) $o_ALM_RequerimientoDetalleBN->setCantidadSugerida( ( float ) $a_ALM_RequerimientoDetalle['CantidadSugerida'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['CantidadPedida'] ) ) $o_ALM_RequerimientoDetalleBN->setCantidadPedida( ( float ) $a_ALM_RequerimientoDetalle['CantidadPedida'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['IdMoneda'] ) ) $o_ALM_RequerimientoDetalleBN->setIdMoneda( $a_ALM_RequerimientoDetalle['IdMoneda'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['IdLote'] ) ) $o_ALM_RequerimientoDetalleBN->setIdLote( $a_ALM_RequerimientoDetalle['IdLote'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['FechaVencimiento'] ) ) $o_ALM_RequerimientoDetalleBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_ALM_RequerimientoDetalle['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_RequerimientoDetalle['StockMinimo'] ) ) $o_ALM_RequerimientoDetalleBN->setStockMinimo( ( float ) $a_ALM_RequerimientoDetalle['StockMinimo'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['StockMaximo'] ) ) $o_ALM_RequerimientoDetalleBN->setStockMaximo( ( float ) $a_ALM_RequerimientoDetalle['StockMaximo'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['PrecioUnitario'] ) ) $o_ALM_RequerimientoDetalleBN->setPrecioUnitario( ( float ) $a_ALM_RequerimientoDetalle['PrecioUnitario'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['PrecioUnitarioIGV'] ) ) $o_ALM_RequerimientoDetalleBN->setPrecioUnitarioIGV( ( float ) $a_ALM_RequerimientoDetalle['PrecioUnitarioIGV'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['PrecioSubTotal'] ) ) $o_ALM_RequerimientoDetalleBN->setPrecioSubTotal( ( float ) $a_ALM_RequerimientoDetalle['PrecioSubTotal'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['ValorIGV'] ) ) $o_ALM_RequerimientoDetalleBN->setValorIGV( ( float ) $a_ALM_RequerimientoDetalle['ValorIGV'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['PrecioTotalConIGV'] ) ) $o_ALM_RequerimientoDetalleBN->setPrecioTotalConIGV( ( float ) $a_ALM_RequerimientoDetalle['PrecioTotalConIGV'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['Estado'] ) ) $o_ALM_RequerimientoDetalleBN->setEstado( $a_ALM_RequerimientoDetalle['Estado'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['IGVExoneradoFlag'] ) ) $o_ALM_RequerimientoDetalleBN->setIGVExoneradoFlag( $a_ALM_RequerimientoDetalle['IGVExoneradoFlag'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['FechaCreacion'] ) ) $o_ALM_RequerimientoDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_RequerimientoDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_RequerimientoDetalle['UsuarioCreacion'] ) ) $o_ALM_RequerimientoDetalleBN->setUsuarioCreacion( $a_ALM_RequerimientoDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['UsuarioModificacion'] ) ) $o_ALM_RequerimientoDetalleBN->setUsuarioModificacion( $a_ALM_RequerimientoDetalle['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_RequerimientoDetalle['FechaModificacion'] ) ) $o_ALM_RequerimientoDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_RequerimientoDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_RequerimientoDetalleBN;
    }
}
?>