<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemAlmacen.xml */
/* Generado: 2022-04-18 21:14:50 */

/* Busqueda de registros de la tabla ALM_ItemAlmacen. */
abstract class BaseALM_ItemAlmacenFN extends ALM_ItemAlmacenBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_ItemAlmacen.IdCompania";
    const IdItem = "ALM_ItemAlmacen.IdItem";
    const IdAlmacen = "ALM_ItemAlmacen.IdAlmacen";
    const IdCondicion = "ALM_ItemAlmacen.IdCondicion";
    const UbicacionFisica = "ALM_ItemAlmacen.UbicacionFisica";
    const UbicacionFisica02 = "ALM_ItemAlmacen.UbicacionFisica02";
    const UbicacionFisica03 = "ALM_ItemAlmacen.UbicacionFisica03";
    const StockPedido = "ALM_ItemAlmacen.StockPedido";
    const StockMinimo = "ALM_ItemAlmacen.StockMinimo";
    const StockMaximo = "ALM_ItemAlmacen.StockMaximo";
    const StockPuntoReorden = "ALM_ItemAlmacen.StockPuntoReorden";
    const TiempoEspera = "ALM_ItemAlmacen.TiempoEspera";
    const ValidacionPedidoComercialFlag = "ALM_ItemAlmacen.ValidacionPedidoComercialFlag";
    const Estado = "ALM_ItemAlmacen.Estado";
    const UsuarioModificacion = "ALM_ItemAlmacen.UsuarioModificacion";
    const FechaModificacion = "ALM_ItemAlmacen.FechaModificacion";
    const UsuarioCreacion = "ALM_ItemAlmacen.UsuarioCreacion";
    const FechaCreacion = "ALM_ItemAlmacen.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_ItemAlmacen.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.IdCondicion AS IdCondicion, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.UbicacionFisica AS UbicacionFisica, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.UbicacionFisica02 AS UbicacionFisica02, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.UbicacionFisica03 AS UbicacionFisica03, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.StockPedido AS StockPedido, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.StockMinimo AS StockMinimo, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.StockMaximo AS StockMaximo, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.StockPuntoReorden AS StockPuntoReorden, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.TiempoEspera AS TiempoEspera, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.ValidacionPedidoComercialFlag AS ValidacionPedidoComercialFlag, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_ItemAlmacen.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_ItemAlmacenBN */
    public function setByBN( ALM_ItemAlmacenBN $o_ALM_ItemAlmacenBN )
    {
        if ( !is_null( $o_ALM_ItemAlmacenBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_ItemAlmacenBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ItemAlmacenBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_ItemAlmacenBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getIdCondicion() ) )
        {
            $this->setIdCondicion( $o_ALM_ItemAlmacenBN->getIdCondicion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_ALM_ItemAlmacenBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getUbicacionFisica02() ) )
        {
            $this->setUbicacionFisica02( $o_ALM_ItemAlmacenBN->getUbicacionFisica02() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getUbicacionFisica03() ) )
        {
            $this->setUbicacionFisica03( $o_ALM_ItemAlmacenBN->getUbicacionFisica03() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getStockPedido() ) )
        {
            $this->setStockPedido( $o_ALM_ItemAlmacenBN->getStockPedido() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getStockMinimo() ) )
        {
            $this->setStockMinimo( $o_ALM_ItemAlmacenBN->getStockMinimo() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getStockMaximo() ) )
        {
            $this->setStockMaximo( $o_ALM_ItemAlmacenBN->getStockMaximo() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getStockPuntoReorden() ) )
        {
            $this->setStockPuntoReorden( $o_ALM_ItemAlmacenBN->getStockPuntoReorden() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getTiempoEspera() ) )
        {
            $this->setTiempoEspera( $o_ALM_ItemAlmacenBN->getTiempoEspera() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getValidacionPedidoComercialFlag() ) )
        {
            $this->setValidacionPedidoComercialFlag( $o_ALM_ItemAlmacenBN->getValidacionPedidoComercialFlag() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_ItemAlmacenBN->getEstado() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemAlmacenBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemAlmacenBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemAlmacenBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemAlmacenBN->getFechaCreacion() );
        }
    }

    /**
    * @return ALM_ItemAlmacenBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdCondicion )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
        if( is_null( $s_IdAlmacen ) ){ $s_IdAlmacen = '-1'; } 
        if( is_null( $s_IdCondicion ) ){ $s_IdCondicion = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemAlmacen ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "AND IdAlmacen = '".$s_IdAlmacen."' ";
        $s_SQLQuery .= "AND IdCondicion = '".$s_IdCondicion."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_ItemAlmacenBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_ItemAlmacenBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ItemAlmacenBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdCondicion() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.IdCondicion = '".$this->getIdCondicion()."' AND ";
        if ( !is_null( $this->getUbicacionFisica() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.UbicacionFisica = '".$this->getUbicacionFisica()."' AND ";
        if ( !is_null( $this->getUbicacionFisica02() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.UbicacionFisica02 = '".$this->getUbicacionFisica02()."' AND ";
        if ( !is_null( $this->getUbicacionFisica03() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.UbicacionFisica03 = '".$this->getUbicacionFisica03()."' AND ";
        if ( !is_null( $this->getStockPedido() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.StockPedido = ".$this->getStockPedido()." AND ";
        if ( !is_null( $this->getStockMinimo() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.StockMinimo = ".$this->getStockMinimo()." AND ";
        if ( !is_null( $this->getStockMaximo() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.StockMaximo = ".$this->getStockMaximo()." AND ";
        if ( !is_null( $this->getStockPuntoReorden() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.StockPuntoReorden = ".$this->getStockPuntoReorden()." AND ";
        if ( !is_null( $this->getTiempoEspera() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.TiempoEspera = ".$this->getTiempoEspera()." AND ";
        if ( !is_null( $this->getValidacionPedidoComercialFlag() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.ValidacionPedidoComercialFlag = '".$this->getValidacionPedidoComercialFlag()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacen.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_ItemAlmacen WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_ItemAlmacenBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemAlmacen WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_ItemAlmacenBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_ItemAlmacenBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_ItemAlmacenBN[] = $o_ALM_ItemAlmacenBN;
            }
        }
        return $a_ALM_ItemAlmacenBN;
    }

    /* Devuelve un objeto ALM_ItemAlmacenBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_ItemAlmacen )
    {
        $o_ALM_ItemAlmacenBN = new ALM_ItemAlmacenBN();
        if ( !is_null( $a_ALM_ItemAlmacen['IdCompania'] ) ) $o_ALM_ItemAlmacenBN->setIdCompania( ( integer ) $a_ALM_ItemAlmacen['IdCompania'] );
        if ( !is_null( $a_ALM_ItemAlmacen['IdItem'] ) ) $o_ALM_ItemAlmacenBN->setIdItem( $a_ALM_ItemAlmacen['IdItem'] );
        if ( !is_null( $a_ALM_ItemAlmacen['IdAlmacen'] ) ) $o_ALM_ItemAlmacenBN->setIdAlmacen( $a_ALM_ItemAlmacen['IdAlmacen'] );
        if ( !is_null( $a_ALM_ItemAlmacen['IdCondicion'] ) ) $o_ALM_ItemAlmacenBN->setIdCondicion( $a_ALM_ItemAlmacen['IdCondicion'] );
        if ( !is_null( $a_ALM_ItemAlmacen['UbicacionFisica'] ) ) $o_ALM_ItemAlmacenBN->setUbicacionFisica( $a_ALM_ItemAlmacen['UbicacionFisica'] );
        if ( !is_null( $a_ALM_ItemAlmacen['UbicacionFisica02'] ) ) $o_ALM_ItemAlmacenBN->setUbicacionFisica02( $a_ALM_ItemAlmacen['UbicacionFisica02'] );
        if ( !is_null( $a_ALM_ItemAlmacen['UbicacionFisica03'] ) ) $o_ALM_ItemAlmacenBN->setUbicacionFisica03( $a_ALM_ItemAlmacen['UbicacionFisica03'] );
        if ( !is_null( $a_ALM_ItemAlmacen['StockPedido'] ) ) $o_ALM_ItemAlmacenBN->setStockPedido( ( integer ) $a_ALM_ItemAlmacen['StockPedido'] );
        if ( !is_null( $a_ALM_ItemAlmacen['StockMinimo'] ) ) $o_ALM_ItemAlmacenBN->setStockMinimo( ( integer ) $a_ALM_ItemAlmacen['StockMinimo'] );
        if ( !is_null( $a_ALM_ItemAlmacen['StockMaximo'] ) ) $o_ALM_ItemAlmacenBN->setStockMaximo( ( integer ) $a_ALM_ItemAlmacen['StockMaximo'] );
        if ( !is_null( $a_ALM_ItemAlmacen['StockPuntoReorden'] ) ) $o_ALM_ItemAlmacenBN->setStockPuntoReorden( ( integer ) $a_ALM_ItemAlmacen['StockPuntoReorden'] );
        if ( !is_null( $a_ALM_ItemAlmacen['TiempoEspera'] ) ) $o_ALM_ItemAlmacenBN->setTiempoEspera( ( integer ) $a_ALM_ItemAlmacen['TiempoEspera'] );
        if ( !is_null( $a_ALM_ItemAlmacen['ValidacionPedidoComercialFlag'] ) ) $o_ALM_ItemAlmacenBN->setValidacionPedidoComercialFlag( $a_ALM_ItemAlmacen['ValidacionPedidoComercialFlag'] );
        if ( !is_null( $a_ALM_ItemAlmacen['Estado'] ) ) $o_ALM_ItemAlmacenBN->setEstado( $a_ALM_ItemAlmacen['Estado'] );
        if ( !is_null( $a_ALM_ItemAlmacen['UsuarioModificacion'] ) ) $o_ALM_ItemAlmacenBN->setUsuarioModificacion( $a_ALM_ItemAlmacen['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_ItemAlmacen['FechaModificacion'] ) ) $o_ALM_ItemAlmacenBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_ItemAlmacen['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemAlmacen['UsuarioCreacion'] ) ) $o_ALM_ItemAlmacenBN->setUsuarioCreacion( $a_ALM_ItemAlmacen['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_ItemAlmacen['FechaCreacion'] ) ) $o_ALM_ItemAlmacenBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_ItemAlmacen['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_ItemAlmacenBN;
    }
}
?>