<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_InventarioFisicoDetalle.xml */
/* Generado: 2022-04-18 21:14:49 */

/* Busqueda de registros de la tabla ALM_InventarioFisicoDetalle. */
abstract class BaseALM_InventarioFisicoDetalleFN extends ALM_InventarioFisicoDetalleBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_InventarioFisicoDetalle.IdCompania";
    const IdNumeroInventario = "ALM_InventarioFisicoDetalle.IdNumeroInventario";
    const IdSecuencia = "ALM_InventarioFisicoDetalle.IdSecuencia";
    const IdAlmacen = "ALM_InventarioFisicoDetalle.IdAlmacen";
    const IdItem = "ALM_InventarioFisicoDetalle.IdItem";
    const IdUnidad = "ALM_InventarioFisicoDetalle.IdUnidad";
    const IdCondicion = "ALM_InventarioFisicoDetalle.IdCondicion";
    const IdLote = "ALM_InventarioFisicoDetalle.IdLote";
    const StockActual = "ALM_InventarioFisicoDetalle.StockActual";
    const StockFisico = "ALM_InventarioFisicoDetalle.StockFisico";
    const StockDiferencia = "ALM_InventarioFisicoDetalle.StockDiferencia";
    const PrecioUnitario = "ALM_InventarioFisicoDetalle.PrecioUnitario";
    const MontoTotal = "ALM_InventarioFisicoDetalle.MontoTotal";
    const UbicacionFisica = "ALM_InventarioFisicoDetalle.UbicacionFisica";
    const TipoOperacion = "ALM_InventarioFisicoDetalle.TipoOperacion";
    const IdTipoDocumentoRef = "ALM_InventarioFisicoDetalle.IdTipoDocumentoRef";
    const IdNumeroDocumentoRef = "ALM_InventarioFisicoDetalle.IdNumeroDocumentoRef";
    const IdSecuenciaRef = "ALM_InventarioFisicoDetalle.IdSecuenciaRef";
    const MuestraKilos = "ALM_InventarioFisicoDetalle.MuestraKilos";
    const MuestraUnidades = "ALM_InventarioFisicoDetalle.MuestraUnidades";
    const MuestraTotalesUnidades = "ALM_InventarioFisicoDetalle.MuestraTotalesUnidades";
    const Estado = "ALM_InventarioFisicoDetalle.Estado";
    const UsuarioCreacion = "ALM_InventarioFisicoDetalle.UsuarioCreacion";
    const FechaCreacion = "ALM_InventarioFisicoDetalle.FechaCreacion";
    const UsuarioModificacion = "ALM_InventarioFisicoDetalle.UsuarioModificacion";
    const FechaModificacion = "ALM_InventarioFisicoDetalle.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_InventarioFisicoDetalle.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdNumeroInventario AS IdNumeroInventario, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdCondicion AS IdCondicion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.StockActual AS StockActual, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.StockFisico AS StockFisico, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.StockDiferencia AS StockDiferencia, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.UbicacionFisica AS UbicacionFisica, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.TipoOperacion AS TipoOperacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdTipoDocumentoRef AS IdTipoDocumentoRef, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdNumeroDocumentoRef AS IdNumeroDocumentoRef, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdSecuenciaRef AS IdSecuenciaRef, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MuestraKilos AS MuestraKilos, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MuestraUnidades AS MuestraUnidades, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MuestraTotalesUnidades AS MuestraTotalesUnidades, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoDetalle.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_InventarioFisicoDetalleBN */
    public function setByBN( ALM_InventarioFisicoDetalleBN $o_ALM_InventarioFisicoDetalleBN )
    {
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_InventarioFisicoDetalleBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdNumeroInventario() ) )
        {
            $this->setIdNumeroInventario( $o_ALM_InventarioFisicoDetalleBN->getIdNumeroInventario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_InventarioFisicoDetalleBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_InventarioFisicoDetalleBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_InventarioFisicoDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_ALM_InventarioFisicoDetalleBN->getIdUnidad() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdCondicion() ) )
        {
            $this->setIdCondicion( $o_ALM_InventarioFisicoDetalleBN->getIdCondicion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_InventarioFisicoDetalleBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getStockActual() ) )
        {
            $this->setStockActual( $o_ALM_InventarioFisicoDetalleBN->getStockActual() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_InventarioFisicoDetalleBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getStockDiferencia() ) )
        {
            $this->setStockDiferencia( $o_ALM_InventarioFisicoDetalleBN->getStockDiferencia() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_ALM_InventarioFisicoDetalleBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_ALM_InventarioFisicoDetalleBN->getMontoTotal() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_ALM_InventarioFisicoDetalleBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getTipoOperacion() ) )
        {
            $this->setTipoOperacion( $o_ALM_InventarioFisicoDetalleBN->getTipoOperacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdTipoDocumentoRef() ) )
        {
            $this->setIdTipoDocumentoRef( $o_ALM_InventarioFisicoDetalleBN->getIdTipoDocumentoRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdNumeroDocumentoRef() ) )
        {
            $this->setIdNumeroDocumentoRef( $o_ALM_InventarioFisicoDetalleBN->getIdNumeroDocumentoRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getIdSecuenciaRef() ) )
        {
            $this->setIdSecuenciaRef( $o_ALM_InventarioFisicoDetalleBN->getIdSecuenciaRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getMuestraKilos() ) )
        {
            $this->setMuestraKilos( $o_ALM_InventarioFisicoDetalleBN->getMuestraKilos() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getMuestraUnidades() ) )
        {
            $this->setMuestraUnidades( $o_ALM_InventarioFisicoDetalleBN->getMuestraUnidades() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getMuestraTotalesUnidades() ) )
        {
            $this->setMuestraTotalesUnidades( $o_ALM_InventarioFisicoDetalleBN->getMuestraTotalesUnidades() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_InventarioFisicoDetalleBN->getEstado() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_InventarioFisicoDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_InventarioFisicoDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_InventarioFisicoDetalleBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_InventarioFisicoDetalleBN->getFechaModificacion() );
        }
    }

    /**
    * @return ALM_InventarioFisicoDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdNumeroInventario, $i_IdSecuencia )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdNumeroInventario ) ){ $s_IdNumeroInventario = '-1'; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_InventarioFisicoDetalle ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdNumeroInventario = '".$s_IdNumeroInventario."' ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_ALM_InventarioFisicoDetalleBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_InventarioFisicoDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_InventarioFisicoDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdNumeroInventario() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdNumeroInventario = '".$this->getIdNumeroInventario()."' AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdUnidad = '".$this->getIdUnidad()."' AND ";
        if ( !is_null( $this->getIdCondicion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdCondicion = '".$this->getIdCondicion()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getStockActual() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.StockActual = ".$this->getStockActual()." AND ";
        if ( !is_null( $this->getStockFisico() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.StockFisico = ".$this->getStockFisico()." AND ";
        if ( !is_null( $this->getStockDiferencia() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.StockDiferencia = ".$this->getStockDiferencia()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getUbicacionFisica() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.UbicacionFisica = '".$this->getUbicacionFisica()."' AND ";
        if ( !is_null( $this->getTipoOperacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.TipoOperacion = '".$this->getTipoOperacion()."' AND ";
        if ( !is_null( $this->getIdTipoDocumentoRef() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdTipoDocumentoRef = '".$this->getIdTipoDocumentoRef()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumentoRef() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdNumeroDocumentoRef = '".$this->getIdNumeroDocumentoRef()."' AND ";
        if ( !is_null( $this->getIdSecuenciaRef() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.IdSecuenciaRef = ".$this->getIdSecuenciaRef()." AND ";
        if ( !is_null( $this->getMuestraKilos() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MuestraKilos = ".$this->getMuestraKilos()." AND ";
        if ( !is_null( $this->getMuestraUnidades() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MuestraUnidades = ".$this->getMuestraUnidades()." AND ";
        if ( !is_null( $this->getMuestraTotalesUnidades() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.MuestraTotalesUnidades = ".$this->getMuestraTotalesUnidades()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_InventarioFisicoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_InventarioFisicoDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_InventarioFisicoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_InventarioFisicoDetalleBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_InventarioFisicoDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_InventarioFisicoDetalleBN[] = $o_ALM_InventarioFisicoDetalleBN;
            }
        }
        return $a_ALM_InventarioFisicoDetalleBN;
    }

    /* Devuelve un objeto ALM_InventarioFisicoDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_InventarioFisicoDetalle )
    {
        $o_ALM_InventarioFisicoDetalleBN = new ALM_InventarioFisicoDetalleBN();
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdCompania'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdCompania( ( integer ) $a_ALM_InventarioFisicoDetalle['IdCompania'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdNumeroInventario'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdNumeroInventario( $a_ALM_InventarioFisicoDetalle['IdNumeroInventario'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdSecuencia'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdSecuencia( ( integer ) $a_ALM_InventarioFisicoDetalle['IdSecuencia'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdAlmacen'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdAlmacen( $a_ALM_InventarioFisicoDetalle['IdAlmacen'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdItem'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdItem( $a_ALM_InventarioFisicoDetalle['IdItem'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdUnidad'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdUnidad( $a_ALM_InventarioFisicoDetalle['IdUnidad'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdCondicion'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdCondicion( $a_ALM_InventarioFisicoDetalle['IdCondicion'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdLote'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdLote( $a_ALM_InventarioFisicoDetalle['IdLote'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['StockActual'] ) ) $o_ALM_InventarioFisicoDetalleBN->setStockActual( ( float ) $a_ALM_InventarioFisicoDetalle['StockActual'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['StockFisico'] ) ) $o_ALM_InventarioFisicoDetalleBN->setStockFisico( ( float ) $a_ALM_InventarioFisicoDetalle['StockFisico'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['StockDiferencia'] ) ) $o_ALM_InventarioFisicoDetalleBN->setStockDiferencia( ( float ) $a_ALM_InventarioFisicoDetalle['StockDiferencia'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['PrecioUnitario'] ) ) $o_ALM_InventarioFisicoDetalleBN->setPrecioUnitario( ( float ) $a_ALM_InventarioFisicoDetalle['PrecioUnitario'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['MontoTotal'] ) ) $o_ALM_InventarioFisicoDetalleBN->setMontoTotal( ( float ) $a_ALM_InventarioFisicoDetalle['MontoTotal'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['UbicacionFisica'] ) ) $o_ALM_InventarioFisicoDetalleBN->setUbicacionFisica( $a_ALM_InventarioFisicoDetalle['UbicacionFisica'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['TipoOperacion'] ) ) $o_ALM_InventarioFisicoDetalleBN->setTipoOperacion( $a_ALM_InventarioFisicoDetalle['TipoOperacion'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdTipoDocumentoRef'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdTipoDocumentoRef( $a_ALM_InventarioFisicoDetalle['IdTipoDocumentoRef'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdNumeroDocumentoRef'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdNumeroDocumentoRef( $a_ALM_InventarioFisicoDetalle['IdNumeroDocumentoRef'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['IdSecuenciaRef'] ) ) $o_ALM_InventarioFisicoDetalleBN->setIdSecuenciaRef( ( integer ) $a_ALM_InventarioFisicoDetalle['IdSecuenciaRef'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['MuestraKilos'] ) ) $o_ALM_InventarioFisicoDetalleBN->setMuestraKilos( ( float ) $a_ALM_InventarioFisicoDetalle['MuestraKilos'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['MuestraUnidades'] ) ) $o_ALM_InventarioFisicoDetalleBN->setMuestraUnidades( ( float ) $a_ALM_InventarioFisicoDetalle['MuestraUnidades'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['MuestraTotalesUnidades'] ) ) $o_ALM_InventarioFisicoDetalleBN->setMuestraTotalesUnidades( ( float ) $a_ALM_InventarioFisicoDetalle['MuestraTotalesUnidades'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['Estado'] ) ) $o_ALM_InventarioFisicoDetalleBN->setEstado( $a_ALM_InventarioFisicoDetalle['Estado'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['UsuarioCreacion'] ) ) $o_ALM_InventarioFisicoDetalleBN->setUsuarioCreacion( $a_ALM_InventarioFisicoDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['FechaCreacion'] ) ) $o_ALM_InventarioFisicoDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_InventarioFisicoDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['UsuarioModificacion'] ) ) $o_ALM_InventarioFisicoDetalleBN->setUsuarioModificacion( $a_ALM_InventarioFisicoDetalle['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_InventarioFisicoDetalle['FechaModificacion'] ) ) $o_ALM_InventarioFisicoDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_InventarioFisicoDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_InventarioFisicoDetalleBN;
    }
}
?>