<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenArchivos.xml */
/* Generado: 2021-03-04 17:13:00 */

/* Mantenimiento de los registros de la tabla VTA_OrdenArchivos */
abstract class BaseVTA_OrdenArchivosDP extends VTA_OrdenArchivosBV
{
    /* Constructor ( Establece los valores desde un objeto VTA_OrdenArchivosBN ) */
    public function __construct( VTA_OrdenArchivosBN $o_VTA_OrdenArchivosBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_VTA_OrdenArchivosBN ) )
        {
            $this->setByBN( $o_VTA_OrdenArchivosBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto VTA_OrdenArchivosBN */
    public function setByBN( VTA_OrdenArchivosBN $o_VTA_OrdenArchivosBN )
    {
        if ( !is_null( $o_VTA_OrdenArchivosBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_VTA_OrdenArchivosBN->getOrdenId() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_VTA_OrdenArchivosBN->getIdSecuencia() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTipoArchivoId() ) )
        {
            $this->setTipoArchivoId( $o_VTA_OrdenArchivosBN->getTipoArchivoId() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getNombre() ) )
        {
            $this->setNombre( $o_VTA_OrdenArchivosBN->getNombre() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTipo() ) )
        {
            $this->setTipo( $o_VTA_OrdenArchivosBN->getTipo() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTipoCompleto() ) )
        {
            $this->setTipoCompleto( $o_VTA_OrdenArchivosBN->getTipoCompleto() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTamanio() ) )
        {
            $this->setTamanio( $o_VTA_OrdenArchivosBN->getTamanio() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getUbicacionURL() ) )
        {
            $this->setUbicacionURL( $o_VTA_OrdenArchivosBN->getUbicacionURL() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_VTA_OrdenArchivosBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_OrdenArchivosBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_OrdenArchivosBN->getUsuarioCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_VTA_OrdenArchivosFN = new VTA_OrdenArchivosFN();
        $o_VTA_OrdenArchivosBN = $o_VTA_OrdenArchivosFN->selectByPk( $this->getOrdenId(), $this->getIdSecuencia() );
        if ( is_null( $o_VTA_OrdenArchivosBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO VTA_OrdenArchivos ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getOrdenId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenId";
                $s_SQLQuery2 .= $s_Separator."".$this->getOrdenId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSecuencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoArchivoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoArchivoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipoArchivoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Tipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoCompleto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoCompleto";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipoCompleto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTamanio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Tamanio";
                $s_SQLQuery2 .= $s_Separator."".$this->getTamanio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionURL() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UbicacionURL";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbicacionURL()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionFisica() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UbicacionFisica";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbicacionFisica()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE VTA_OrdenArchivos SET ";
            $s_Separator = "";
            if ( !is_null( $this->getTipoArchivoId() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoArchivoId = ".$this->getTipoArchivoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."Tipo = '".$this->getTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoCompleto() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoCompleto = '".$this->getTipoCompleto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTamanio() ) )
            {
                $s_SQLQuery .= $s_Separator."Tamanio = ".$this->getTamanio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionURL() ) )
            {
                $s_SQLQuery .= $s_Separator."UbicacionURL = '".$this->getUbicacionURL()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionFisica() ) )
            {
                $s_SQLQuery .= $s_Separator."UbicacionFisica = '".$this->getUbicacionFisica()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  OrdenId = ".$this->getOrdenId()." AND  IdSecuencia = ".$this->getIdSecuencia().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM VTA_OrdenArchivos WHERE  OrdenId = ".$this->getOrdenId()." AND  IdSecuencia = ".$this->getIdSecuencia().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>