<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Ruta.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Mantenimiento de los registros de la tabla TR_Ruta */
abstract class BaseTR_RutaDP extends TR_RutaBV
{
    /* Constructor ( Establece los valores desde un objeto TR_RutaBN ) */
    public function __construct( TR_RutaBN $o_TR_RutaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_TR_RutaBN ) )
        {
            $this->setByBN( $o_TR_RutaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto TR_RutaBN */
    public function setByBN( TR_RutaBN $o_TR_RutaBN )
    {
        if ( !is_null( $o_TR_RutaBN->getIdRuta() ) )
        {
            $this->setIdRuta( $o_TR_RutaBN->getIdRuta() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_TR_RutaBN->getIdCompania() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_TR_RutaBN->getIdSucursal() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaDocumento() ) )
        {
            $this->setRutaDocumento( $o_TR_RutaBN->getRutaDocumento() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaProgramada() ) )
        {
            $this->setRutaFechaProgramada( $o_TR_RutaBN->getRutaFechaProgramada() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_TR_RutaBN->getIdTurno() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdVehiculo() ) )
        {
            $this->setIdVehiculo( $o_TR_RutaBN->getIdVehiculo() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdChofer() ) )
        {
            $this->setIdChofer( $o_TR_RutaBN->getIdChofer() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaEmision() ) )
        {
            $this->setRutaFechaEmision( $o_TR_RutaBN->getRutaFechaEmision() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaPartida() ) )
        {
            $this->setRutaFechaPartida( $o_TR_RutaBN->getRutaFechaPartida() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaLlegada() ) )
        {
            $this->setRutaFechaLlegada( $o_TR_RutaBN->getRutaFechaLlegada() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaComentario() ) )
        {
            $this->setRutaComentario( $o_TR_RutaBN->getRutaComentario() );
        }
        if ( !is_null( $o_TR_RutaBN->getEstado() ) )
        {
            $this->setEstado( $o_TR_RutaBN->getEstado() );
        }
        if ( !is_null( $o_TR_RutaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_TR_RutaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_TR_RutaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_TR_RutaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_TR_RutaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_TR_RutaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_TR_RutaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_TR_RutaBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_TR_RutaFN = new TR_RutaFN();
        $o_TR_RutaBN = $o_TR_RutaFN->selectByPk( $this->getIdRuta() );
        if ( is_null( $o_TR_RutaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO TR_Ruta ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdRuta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRuta";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdRuta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RutaDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRutaDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaProgramada() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RutaFechaProgramada";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRutaFechaProgramada()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTurno";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdVehiculo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdVehiculo";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdVehiculo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdChofer() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdChofer";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdChofer()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaEmision() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RutaFechaEmision";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRutaFechaEmision()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaPartida() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RutaFechaPartida";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRutaFechaPartida()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaLlegada() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RutaFechaLlegada";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRutaFechaLlegada()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RutaComentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRutaComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE TR_Ruta SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."RutaDocumento = '".$this->getRutaDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaProgramada() ) )
            {
                $s_SQLQuery .= $s_Separator."RutaFechaProgramada = '".$this->getRutaFechaProgramada()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTurno = ".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdVehiculo() ) )
            {
                $s_SQLQuery .= $s_Separator."IdVehiculo = ".$this->getIdVehiculo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdChofer() ) )
            {
                $s_SQLQuery .= $s_Separator."IdChofer = ".$this->getIdChofer()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaEmision() ) )
            {
                $s_SQLQuery .= $s_Separator."RutaFechaEmision = '".$this->getRutaFechaEmision()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaPartida() ) )
            {
                $s_SQLQuery .= $s_Separator."RutaFechaPartida = '".$this->getRutaFechaPartida()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaFechaLlegada() ) )
            {
                $s_SQLQuery .= $s_Separator."RutaFechaLlegada = '".$this->getRutaFechaLlegada()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."RutaComentario = '".$this->getRutaComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdRuta = ".$this->getIdRuta().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM TR_Ruta WHERE  IdRuta = ".$this->getIdRuta().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>