<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_PreLoteEscaneo.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Mantenimiento de los registros de la tabla SR_PreLoteEscaneo */
abstract class BaseSR_PreLoteEscaneoDP extends SR_PreLoteEscaneoBV
{
    /* Constructor ( Establece los valores desde un objeto SR_PreLoteEscaneoBN ) */
    public function __construct( SR_PreLoteEscaneoBN $o_SR_PreLoteEscaneoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SR_PreLoteEscaneoBN ) )
        {
            $this->setByBN( $o_SR_PreLoteEscaneoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SR_PreLoteEscaneoBN */
    public function setByBN( SR_PreLoteEscaneoBN $o_SR_PreLoteEscaneoBN )
    {
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_PreLoteEscaneoBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SR_PreLoteEscaneoBN->getSecuencia() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getLote() ) )
        {
            $this->setLote( $o_SR_PreLoteEscaneoBN->getLote() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_PreLoteEscaneoBN->getCantidad() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_PreLoteEscaneoBN->getFecha() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_PreLoteEscaneoBN->getComentario() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_PreLoteEscaneoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_PreLoteEscaneoBN->getFechaRegistro() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SR_PreLoteEscaneoFN = new SR_PreLoteEscaneoFN();
        $o_SR_PreLoteEscaneoBN = $o_SR_PreLoteEscaneoFN->selectByPk( $this->getMovimientoDetalleId(), $this->getSecuencia() );
        if ( is_null( $o_SR_PreLoteEscaneoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SR_PreLoteEscaneo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getMovimientoDetalleId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoDetalleId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoDetalleId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Secuencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLote() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Lote";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLote()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Cantidad";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Fecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SR_PreLoteEscaneo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getLote() ) )
            {
                $s_SQLQuery .= $s_Separator."Lote = '".$this->getLote()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery .= $s_Separator."Cantidad = ".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery .= $s_Separator."Fecha = '".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND  Secuencia = ".$this->getSecuencia().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SR_PreLoteEscaneo WHERE  MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND  Secuencia = ".$this->getSecuencia().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>