<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionLimpieza.xml */
/* Generado: 2021-07-03 05:25:44 */

/* Mantenimiento de los registros de la tabla SR_DevolucionLimpieza */
abstract class BaseSR_DevolucionLimpiezaDP extends SR_DevolucionLimpiezaBV
{
    /* Constructor ( Establece los valores desde un objeto SR_DevolucionLimpiezaBN ) */
    public function __construct( SR_DevolucionLimpiezaBN $o_SR_DevolucionLimpiezaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SR_DevolucionLimpiezaBN ) )
        {
            $this->setByBN( $o_SR_DevolucionLimpiezaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SR_DevolucionLimpiezaBN */
    public function setByBN( SR_DevolucionLimpiezaBN $o_SR_DevolucionLimpiezaBN )
    {
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getLimpiezaId() ) )
        {
            $this->setLimpiezaId( $o_SR_DevolucionLimpiezaBN->getLimpiezaId() );
        }
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_SR_DevolucionLimpiezaBN->getDescripcion() );
        }
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_DevolucionLimpiezaBN->getCantidad() );
        }
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getTipo() ) )
        {
            $this->setTipo( $o_SR_DevolucionLimpiezaBN->getTipo() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SR_DevolucionLimpiezaFN = new SR_DevolucionLimpiezaFN();
        $o_SR_DevolucionLimpiezaBN = $o_SR_DevolucionLimpiezaFN->selectByPk( $this->getLimpiezaId() );
        if ( is_null( $o_SR_DevolucionLimpiezaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SR_DevolucionLimpieza ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getLimpiezaId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LimpiezaId";
                $s_SQLQuery2 .= $s_Separator."".$this->getLimpiezaId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Cantidad";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Tipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipo()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SR_DevolucionLimpieza SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery .= $s_Separator."Cantidad = ".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."Tipo = '".$this->getTipo()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  LimpiezaId = ".$this->getLimpiezaId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SR_DevolucionLimpieza WHERE  LimpiezaId = ".$this->getLimpiezaId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>