<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SRV_UbicacionEstado.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Mantenimiento de los registros de la tabla SRV_UbicacionEstado */
abstract class BaseSRV_UbicacionEstadoDP extends SRV_UbicacionEstadoBV
{
    /* Constructor ( Establece los valores desde un objeto SRV_UbicacionEstadoBN ) */
    public function __construct( SRV_UbicacionEstadoBN $o_SRV_UbicacionEstadoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SRV_UbicacionEstadoBN ) )
        {
            $this->setByBN( $o_SRV_UbicacionEstadoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SRV_UbicacionEstadoBN */
    public function setByBN( SRV_UbicacionEstadoBN $o_SRV_UbicacionEstadoBN )
    {
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getIdUbicacion() ) )
        {
            $this->setIdUbicacion( $o_SRV_UbicacionEstadoBN->getIdUbicacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getIdEstados() ) )
        {
            $this->setIdEstados( $o_SRV_UbicacionEstadoBN->getIdEstados() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getEstadoNombre() ) )
        {
            $this->setEstadoNombre( $o_SRV_UbicacionEstadoBN->getEstadoNombre() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SRV_UbicacionEstadoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SRV_UbicacionEstadoBN->getUsuarioCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SRV_UbicacionEstadoFN = new SRV_UbicacionEstadoFN();
        $o_SRV_UbicacionEstadoBN = $o_SRV_UbicacionEstadoFN->selectByPk( $this->getIdUbicacion() );
        if ( is_null( $o_SRV_UbicacionEstadoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SRV_UbicacionEstado ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdUbicacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUbicacion";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdUbicacion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdEstados() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdEstados";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdEstados()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstadoNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EstadoNombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstadoNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SRV_UbicacionEstado SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdEstados() ) )
            {
                $s_SQLQuery .= $s_Separator."IdEstados = ".$this->getIdEstados()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstadoNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."EstadoNombre = '".$this->getEstadoNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdUbicacion = ".$this->getIdUbicacion().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SRV_UbicacionEstado WHERE  IdUbicacion = ".$this->getIdUbicacion().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>