<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_TareaRol.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Mantenimiento de los registros de la tabla SEG_TareaRol */
abstract class BaseSEG_TareaRolDP extends SEG_TareaRolBV
{
    /* Constructor ( Establece los valores desde un objeto SEG_TareaRolBN ) */
    public function __construct( SEG_TareaRolBN $o_SEG_TareaRolBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SEG_TareaRolBN ) )
        {
            $this->setByBN( $o_SEG_TareaRolBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SEG_TareaRolBN */
    public function setByBN( SEG_TareaRolBN $o_SEG_TareaRolBN )
    {
        if ( !is_null( $o_SEG_TareaRolBN->getIdRol() ) )
        {
            $this->setIdRol( $o_SEG_TareaRolBN->getIdRol() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getIdTarea() ) )
        {
            $this->setIdTarea( $o_SEG_TareaRolBN->getIdTarea() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_TareaRolBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_TareaRolBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_TareaRolBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_TareaRolBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SEG_TareaRolFN = new SEG_TareaRolFN();
        $o_SEG_TareaRolBN = $o_SEG_TareaRolFN->selectByPk( $this->getIdRol(), $this->getIdTarea() );
        if ( is_null( $o_SEG_TareaRolBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SEG_TareaRol ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdRol() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRol";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdRol()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTarea() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTarea";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTarea()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SEG_TareaRol SET ";
            $s_Separator = "";
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdRol = '".$this->getIdRol()."' AND  IdTarea = '".$this->getIdTarea()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SEG_TareaRol WHERE  IdRol = '".$this->getIdRol()."' AND  IdTarea = '".$this->getIdTarea()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>