<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_SucursalUsuario.xml */
/* Generado: 2024-11-12 17:32:16 */

/* Mantenimiento de los registros de la tabla SEG_SucursalUsuario */
abstract class BaseSEG_SucursalUsuarioDP extends SEG_SucursalUsuarioBV
{
    /* Constructor ( Establece los valores desde un objeto SEG_SucursalUsuarioBN ) */
    public function __construct( SEG_SucursalUsuarioBN $o_SEG_SucursalUsuarioBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SEG_SucursalUsuarioBN ) )
        {
            $this->setByBN( $o_SEG_SucursalUsuarioBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SEG_SucursalUsuarioBN */
    public function setByBN( SEG_SucursalUsuarioBN $o_SEG_SucursalUsuarioBN )
    {
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_SEG_SucursalUsuarioBN->getIdUsuario() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SEG_SucursalUsuarioBN->getIdSucursal() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SEG_SucursalUsuarioBN->getIdCompania() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_SEG_SucursalUsuarioBN->getIdAlmacen() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getEstado() ) )
        {
            $this->setEstado( $o_SEG_SucursalUsuarioBN->getEstado() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_SucursalUsuarioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_SucursalUsuarioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_SucursalUsuarioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_SucursalUsuarioBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SEG_SucursalUsuarioFN = new SEG_SucursalUsuarioFN();
        $o_SEG_SucursalUsuarioBN = $o_SEG_SucursalUsuarioFN->selectByPk( $this->getIdUsuario(), $this->getIdSucursal() );
        if ( is_null( $o_SEG_SucursalUsuarioBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SEG_SucursalUsuario ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdUsuario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUsuario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdUsuario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAlmacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SEG_SucursalUsuario SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery .= $s_Separator."IdAlmacen = '".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdUsuario = '".$this->getIdUsuario()."' AND  IdSucursal = ".$this->getIdSucursal().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SEG_SucursalUsuario WHERE  IdUsuario = '".$this->getIdUsuario()."' AND  IdSucursal = ".$this->getIdSucursal().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>