<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Rol.xml */
/* Generado: 2021-09-21 03:37:38 */

/* Mantenimiento de los registros de la tabla SEG_Rol */
abstract class BaseSEG_RolDP extends SEG_RolBV
{
    /* Constructor ( Establece los valores desde un objeto SEG_RolBN ) */
    public function __construct( SEG_RolBN $o_SEG_RolBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SEG_RolBN ) )
        {
            $this->setByBN( $o_SEG_RolBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SEG_RolBN */
    public function setByBN( SEG_RolBN $o_SEG_RolBN )
    {
        if ( !is_null( $o_SEG_RolBN->getIdRol() ) )
        {
            $this->setIdRol( $o_SEG_RolBN->getIdRol() );
        }
        if ( !is_null( $o_SEG_RolBN->getRolDescripcion() ) )
        {
            $this->setRolDescripcion( $o_SEG_RolBN->getRolDescripcion() );
        }
        if ( !is_null( $o_SEG_RolBN->getIdTareaInicio() ) )
        {
            $this->setIdTareaInicio( $o_SEG_RolBN->getIdTareaInicio() );
        }
        if ( !is_null( $o_SEG_RolBN->getAccesoGlobal() ) )
        {
            $this->setAccesoGlobal( $o_SEG_RolBN->getAccesoGlobal() );
        }
        if ( !is_null( $o_SEG_RolBN->getEsAdministrador() ) )
        {
            $this->setEsAdministrador( $o_SEG_RolBN->getEsAdministrador() );
        }
        if ( !is_null( $o_SEG_RolBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_RolBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_RolBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_RolBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_RolBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_RolBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_RolBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_RolBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SEG_RolFN = new SEG_RolFN();
        $o_SEG_RolBN = $o_SEG_RolFN->selectByPk( $this->getIdRol() );
        if ( is_null( $o_SEG_RolBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SEG_Rol ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdRol() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRol";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdRol()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRolDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RolDescripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRolDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTareaInicio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTareaInicio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTareaInicio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAccesoGlobal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AccesoGlobal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAccesoGlobal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsAdministrador() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsAdministrador";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEsAdministrador()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SEG_Rol SET ";
            $s_Separator = "";
            if ( !is_null( $this->getRolDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."RolDescripcion = '".$this->getRolDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTareaInicio() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTareaInicio = '".$this->getIdTareaInicio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAccesoGlobal() ) )
            {
                $s_SQLQuery .= $s_Separator."AccesoGlobal = '".$this->getAccesoGlobal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsAdministrador() ) )
            {
                $s_SQLQuery .= $s_Separator."EsAdministrador = '".$this->getEsAdministrador()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdRol = '".$this->getIdRol()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SEG_Rol WHERE  IdRol = '".$this->getIdRol()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>