<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Patron.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Mantenimiento de los registros de la tabla SEG_Patron */
abstract class BaseSEG_PatronDP extends SEG_PatronBV
{
    /* Constructor ( Establece los valores desde un objeto SEG_PatronBN ) */
    public function __construct( SEG_PatronBN $o_SEG_PatronBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SEG_PatronBN ) )
        {
            $this->setByBN( $o_SEG_PatronBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SEG_PatronBN */
    public function setByBN( SEG_PatronBN $o_SEG_PatronBN )
    {
        if ( !is_null( $o_SEG_PatronBN->getIdPatron() ) )
        {
            $this->setIdPatron( $o_SEG_PatronBN->getIdPatron() );
        }
        if ( !is_null( $o_SEG_PatronBN->getPatronDescripcion() ) )
        {
            $this->setPatronDescripcion( $o_SEG_PatronBN->getPatronDescripcion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getPatronLongDesc() ) )
        {
            $this->setPatronLongDesc( $o_SEG_PatronBN->getPatronLongDesc() );
        }
        if ( !is_null( $o_SEG_PatronBN->getVisibleScreen() ) )
        {
            $this->setVisibleScreen( $o_SEG_PatronBN->getVisibleScreen() );
        }
        if ( !is_null( $o_SEG_PatronBN->getContextoPreselec() ) )
        {
            $this->setContextoPreselec( $o_SEG_PatronBN->getContextoPreselec() );
        }
        if ( !is_null( $o_SEG_PatronBN->getMantenerDatos() ) )
        {
            $this->setMantenerDatos( $o_SEG_PatronBN->getMantenerDatos() );
        }
        if ( !is_null( $o_SEG_PatronBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_PatronBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_PatronBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_PatronBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_PatronBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SEG_PatronFN = new SEG_PatronFN();
        $o_SEG_PatronBN = $o_SEG_PatronFN->selectByPk( $this->getIdPatron() );
        if ( is_null( $o_SEG_PatronBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SEG_Patron ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdPatron() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPatron";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdPatron()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPatronDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PatronDescripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPatronDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPatronLongDesc() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PatronLongDesc";
                $s_SQLQuery2 .= $s_Separator."".$this->getPatronLongDesc()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getVisibleScreen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."VisibleScreen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getVisibleScreen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getContextoPreselec() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ContextoPreselec";
                $s_SQLQuery2 .= $s_Separator."'".$this->getContextoPreselec()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMantenerDatos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MantenerDatos";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMantenerDatos()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SEG_Patron SET ";
            $s_Separator = "";
            if ( !is_null( $this->getPatronDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."PatronDescripcion = '".$this->getPatronDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPatronLongDesc() ) )
            {
                $s_SQLQuery .= $s_Separator."PatronLongDesc = ".$this->getPatronLongDesc()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getVisibleScreen() ) )
            {
                $s_SQLQuery .= $s_Separator."VisibleScreen = '".$this->getVisibleScreen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getContextoPreselec() ) )
            {
                $s_SQLQuery .= $s_Separator."ContextoPreselec = '".$this->getContextoPreselec()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMantenerDatos() ) )
            {
                $s_SQLQuery .= $s_Separator."MantenerDatos = '".$this->getMantenerDatos()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdPatron = '".$this->getIdPatron()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SEG_Patron WHERE  IdPatron = '".$this->getIdPatron()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>