<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Menu.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Mantenimiento de los registros de la tabla SEG_Menu */
abstract class BaseSEG_MenuDP extends SEG_MenuBV
{
    /* Constructor ( Establece los valores desde un objeto SEG_MenuBN ) */
    public function __construct( SEG_MenuBN $o_SEG_MenuBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SEG_MenuBN ) )
        {
            $this->setByBN( $o_SEG_MenuBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SEG_MenuBN */
    public function setByBN( SEG_MenuBN $o_SEG_MenuBN )
    {
        if ( !is_null( $o_SEG_MenuBN->getIdMenu() ) )
        {
            $this->setIdMenu( $o_SEG_MenuBN->getIdMenu() );
        }
        if ( !is_null( $o_SEG_MenuBN->getIdTareaHijo() ) )
        {
            $this->setIdTareaHijo( $o_SEG_MenuBN->getIdTareaHijo() );
        }
        if ( !is_null( $o_SEG_MenuBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SEG_MenuBN->getSecuencia() );
        }
        if ( !is_null( $o_SEG_MenuBN->getBotonTexto() ) )
        {
            $this->setBotonTexto( $o_SEG_MenuBN->getBotonTexto() );
        }
        if ( !is_null( $o_SEG_MenuBN->getEstado() ) )
        {
            $this->setEstado( $o_SEG_MenuBN->getEstado() );
        }
        if ( !is_null( $o_SEG_MenuBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_MenuBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_MenuBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_MenuBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_MenuBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_MenuBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_MenuBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_MenuBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SEG_MenuFN = new SEG_MenuFN();
        $o_SEG_MenuBN = $o_SEG_MenuFN->selectByPk( $this->getIdMenu(), $this->getIdTareaHijo() );
        if ( is_null( $o_SEG_MenuBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SEG_Menu ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdMenu() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMenu";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMenu()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTareaHijo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTareaHijo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTareaHijo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Secuencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSecuencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getBotonTexto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."BotonTexto";
                $s_SQLQuery2 .= $s_Separator."'".$this->getBotonTexto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."".$this->getEstado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SEG_Menu SET ";
            $s_Separator = "";
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery .= $s_Separator."Secuencia = '".$this->getSecuencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getBotonTexto() ) )
            {
                $s_SQLQuery .= $s_Separator."BotonTexto = '".$this->getBotonTexto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = ".$this->getEstado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdMenu = '".$this->getIdMenu()."' AND  IdTareaHijo = '".$this->getIdTareaHijo()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SEG_Menu WHERE  IdMenu = '".$this->getIdMenu()."' AND  IdTareaHijo = '".$this->getIdTareaHijo()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>