<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: products.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Mantenimiento de los registros de la tabla products */
abstract class BaseProductsDP extends ProductsBV
{
    /* Constructor ( Establece los valores desde un objeto ProductsBN ) */
    public function __construct( ProductsBN $o_ProductsBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ProductsBN ) )
        {
            $this->setByBN( $o_ProductsBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ProductsBN */
    public function setByBN( ProductsBN $o_ProductsBN )
    {
        if ( !is_null( $o_ProductsBN->getId() ) )
        {
            $this->setId( $o_ProductsBN->getId() );
        }
        if ( !is_null( $o_ProductsBN->getName() ) )
        {
            $this->setName( $o_ProductsBN->getName() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_productsFN = new ProductsFN();
        $o_productsBN = $o_productsFN->selectByPk( $this->getId() );
        if ( is_null( $o_productsBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO products ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."id";
                $s_SQLQuery2 .= $s_Separator."".$this->getId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getName() ) )
            {
                $s_SQLQuery1 .= $s_Separator."name";
                $s_SQLQuery2 .= $s_Separator."'".$this->getName()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE products SET ";
            $s_Separator = "";
            if ( !is_null( $this->getName() ) )
            {
                $s_SQLQuery .= $s_Separator."name = '".$this->getName()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  id = ".$this->getId().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM products WHERE  id = ".$this->getId().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>