<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRO_CierreMensual.xml */
/* Generado: 2021-08-19 23:43:58 */

/* Mantenimiento de los registros de la tabla PRO_CierreMensual */
abstract class BasePRO_CierreMensualDP extends PRO_CierreMensualBV
{
    /* Constructor ( Establece los valores desde un objeto PRO_CierreMensualBN ) */
    public function __construct( PRO_CierreMensualBN $o_PRO_CierreMensualBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PRO_CierreMensualBN ) )
        {
            $this->setByBN( $o_PRO_CierreMensualBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PRO_CierreMensualBN */
    public function setByBN( PRO_CierreMensualBN $o_PRO_CierreMensualBN )
    {
        if ( !is_null( $o_PRO_CierreMensualBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_PRO_CierreMensualBN->getIdCompania() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getIdPeriodo() ) )
        {
            $this->setIdPeriodo( $o_PRO_CierreMensualBN->getIdPeriodo() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getAnio() ) )
        {
            $this->setAnio( $o_PRO_CierreMensualBN->getAnio() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getMes() ) )
        {
            $this->setMes( $o_PRO_CierreMensualBN->getMes() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getEstado() ) )
        {
            $this->setEstado( $o_PRO_CierreMensualBN->getEstado() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getComentario() ) )
        {
            $this->setComentario( $o_PRO_CierreMensualBN->getComentario() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PRO_CierreMensualBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PRO_CierreMensualBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRO_CierreMensualBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRO_CierreMensualBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PRO_CierreMensualFN = new PRO_CierreMensualFN();
        $o_PRO_CierreMensualBN = $o_PRO_CierreMensualFN->selectByPk( $this->getIdCompania(), $this->getIdPeriodo() );
        if ( is_null( $o_PRO_CierreMensualBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PRO_CierreMensual ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdPeriodo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPeriodo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdPeriodo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAnio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Anio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAnio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMes() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Mes";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMes()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PRO_CierreMensual SET ";
            $s_Separator = "";
            if ( !is_null( $this->getAnio() ) )
            {
                $s_SQLQuery .= $s_Separator."Anio = '".$this->getAnio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMes() ) )
            {
                $s_SQLQuery .= $s_Separator."Mes = '".$this->getMes()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdPeriodo = '".$this->getIdPeriodo()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PRO_CierreMensual WHERE  IdCompania = ".$this->getIdCompania()." AND  IdPeriodo = '".$this->getIdPeriodo()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>