<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_ManoObra.xml */
/* Generado: 2021-03-27 01:33:47 */

/* Mantenimiento de los registros de la tabla PRD_ManoObra */
abstract class BasePRD_ManoObraDP extends PRD_ManoObraBV
{
    /* Constructor ( Establece los valores desde un objeto PRD_ManoObraBN ) */
    public function __construct( PRD_ManoObraBN $o_PRD_ManoObraBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PRD_ManoObraBN ) )
        {
            $this->setByBN( $o_PRD_ManoObraBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PRD_ManoObraBN */
    public function setByBN( PRD_ManoObraBN $o_PRD_ManoObraBN )
    {
        if ( !is_null( $o_PRD_ManoObraBN->getIdManoObra() ) )
        {
            $this->setIdManoObra( $o_PRD_ManoObraBN->getIdManoObra() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PRD_ManoObraBN->getDescripcion() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getEstado() ) )
        {
            $this->setEstado( $o_PRD_ManoObraBN->getEstado() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_PRD_ManoObraBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_PRD_ManoObraBN->getFechaRegistro() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_ManoObraBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_ManoObraBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PRD_ManoObraFN = new PRD_ManoObraFN();
        $o_PRD_ManoObraBN = $o_PRD_ManoObraFN->selectByPk( $this->getIdManoObra() );
        if ( is_null( $o_PRD_ManoObraBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PRD_ManoObra ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdManoObra() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdManoObra";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdManoObra()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PRD_ManoObra SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdManoObra = ".$this->getIdManoObra().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PRD_ManoObra WHERE  IdManoObra = ".$this->getIdManoObra().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>