<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_EquipoHerramienta.xml */
/* Generado: 2021-03-29 22:24:40 */

/* Mantenimiento de los registros de la tabla PRD_EquipoHerramienta */
abstract class BasePRD_EquipoHerramientaDP extends PRD_EquipoHerramientaBV
{
    /* Constructor ( Establece los valores desde un objeto PRD_EquipoHerramientaBN ) */
    public function __construct( PRD_EquipoHerramientaBN $o_PRD_EquipoHerramientaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PRD_EquipoHerramientaBN ) )
        {
            $this->setByBN( $o_PRD_EquipoHerramientaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PRD_EquipoHerramientaBN */
    public function setByBN( PRD_EquipoHerramientaBN $o_PRD_EquipoHerramientaBN )
    {
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getIdEquiHerr() ) )
        {
            $this->setIdEquiHerr( $o_PRD_EquipoHerramientaBN->getIdEquiHerr() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PRD_EquipoHerramientaBN->getDescripcion() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getEstado() ) )
        {
            $this->setEstado( $o_PRD_EquipoHerramientaBN->getEstado() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_PRD_EquipoHerramientaBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_PRD_EquipoHerramientaBN->getFechaRegistro() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_EquipoHerramientaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_EquipoHerramientaBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PRD_EquipoHerramientaFN = new PRD_EquipoHerramientaFN();
        $o_PRD_EquipoHerramientaBN = $o_PRD_EquipoHerramientaFN->selectByPk( $this->getIdEquiHerr() );
        if ( is_null( $o_PRD_EquipoHerramientaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PRD_EquipoHerramienta ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdEquiHerr() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdEquiHerr";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdEquiHerr()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PRD_EquipoHerramienta SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdEquiHerr = ".$this->getIdEquiHerr().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PRD_EquipoHerramienta WHERE  IdEquiHerr = ".$this->getIdEquiHerr().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>