<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoUbicacion.xml */
/* Generado: 2020-08-18 04:21:28 */

/* Mantenimiento de los registros de la tabla MST_TipoUbicacion */
abstract class BaseMST_TipoUbicacionDP extends MST_TipoUbicacionBV
{
    /* Constructor ( Establece los valores desde un objeto MST_TipoUbicacionBN ) */
    public function __construct( MST_TipoUbicacionBN $o_MST_TipoUbicacionBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_TipoUbicacionBN ) )
        {
            $this->setByBN( $o_MST_TipoUbicacionBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_TipoUbicacionBN */
    public function setByBN( MST_TipoUbicacionBN $o_MST_TipoUbicacionBN )
    {
        if ( !is_null( $o_MST_TipoUbicacionBN->getIdTipoUbicacion() ) )
        {
            $this->setIdTipoUbicacion( $o_MST_TipoUbicacionBN->getIdTipoUbicacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_TipoUbicacionBN->getNombre() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getNivel() ) )
        {
            $this->setNivel( $o_MST_TipoUbicacionBN->getNivel() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getImagenUbicacion() ) )
        {
            $this->setImagenUbicacion( $o_MST_TipoUbicacionBN->getImagenUbicacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TipoUbicacionBN->getEstado() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TipoUbicacionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TipoUbicacionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TipoUbicacionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TipoUbicacionBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_TipoUbicacionFN = new MST_TipoUbicacionFN();
        $o_MST_TipoUbicacionBN = $o_MST_TipoUbicacionFN->selectByPk( $this->getIdTipoUbicacion() );
        if ( is_null( $o_MST_TipoUbicacionBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_TipoUbicacion ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTipoUbicacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoUbicacion";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTipoUbicacion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNivel() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nivel";
                $s_SQLQuery2 .= $s_Separator."".$this->getNivel()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getImagenUbicacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ImagenUbicacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getImagenUbicacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_TipoUbicacion SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNivel() ) )
            {
                $s_SQLQuery .= $s_Separator."Nivel = ".$this->getNivel()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getImagenUbicacion() ) )
            {
                $s_SQLQuery .= $s_Separator."ImagenUbicacion = '".$this->getImagenUbicacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTipoUbicacion = ".$this->getIdTipoUbicacion().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_TipoUbicacion WHERE  IdTipoUbicacion = ".$this->getIdTipoUbicacion().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>