<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoGarantia.xml */
/* Generado: 2020-08-18 04:21:28 */

/* Mantenimiento de los registros de la tabla MST_TipoGarantia */
abstract class BaseMST_TipoGarantiaDP extends MST_TipoGarantiaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_TipoGarantiaBN ) */
    public function __construct( MST_TipoGarantiaBN $o_MST_TipoGarantiaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_TipoGarantiaBN ) )
        {
            $this->setByBN( $o_MST_TipoGarantiaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_TipoGarantiaBN */
    public function setByBN( MST_TipoGarantiaBN $o_MST_TipoGarantiaBN )
    {
        if ( !is_null( $o_MST_TipoGarantiaBN->getTipoGarantiaId() ) )
        {
            $this->setTipoGarantiaId( $o_MST_TipoGarantiaBN->getTipoGarantiaId() );
        }
        if ( !is_null( $o_MST_TipoGarantiaBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_TipoGarantiaBN->getNombre() );
        }
        if ( !is_null( $o_MST_TipoGarantiaBN->getNumeroDias() ) )
        {
            $this->setNumeroDias( $o_MST_TipoGarantiaBN->getNumeroDias() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_TipoGarantiaFN = new MST_TipoGarantiaFN();
        $o_MST_TipoGarantiaBN = $o_MST_TipoGarantiaFN->selectByPk( $this->getTipoGarantiaId() );
        if ( is_null( $o_MST_TipoGarantiaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_TipoGarantia ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getTipoGarantiaId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoGarantiaId";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipoGarantiaId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroDias() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NumeroDias";
                $s_SQLQuery2 .= $s_Separator."".$this->getNumeroDias()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_TipoGarantia SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroDias() ) )
            {
                $s_SQLQuery .= $s_Separator."NumeroDias = ".$this->getNumeroDias()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  TipoGarantiaId = ".$this->getTipoGarantiaId().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_TipoGarantia WHERE  TipoGarantiaId = ".$this->getTipoGarantiaId().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>