<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProductoCatTalla.xml */
/* Generado: 2024-08-20 23:01:57 */

/* Mantenimiento de los registros de la tabla MST_ReferenciaProductoCatTalla */
abstract class BaseMST_ReferenciaProductoCatTallaDP extends MST_ReferenciaProductoCatTallaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ReferenciaProductoCatTallaBN ) */
    public function __construct( MST_ReferenciaProductoCatTallaBN $o_MST_ReferenciaProductoCatTallaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN ) )
        {
            $this->setByBN( $o_MST_ReferenciaProductoCatTallaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ReferenciaProductoCatTallaBN */
    public function setByBN( MST_ReferenciaProductoCatTallaBN $o_MST_ReferenciaProductoCatTallaBN )
    {
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_ReferenciaProductoCatTallaBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_ReferenciaProductoCatTallaBN->getIdColor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_ReferenciaProductoCatTallaBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getAplicado() ) )
        {
            $this->setAplicado( $o_MST_ReferenciaProductoCatTallaBN->getAplicado() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ReferenciaProductoCatTallaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ReferenciaProductoCatTallaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoCatTallaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ReferenciaProductoCatTallaBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ReferenciaProductoCatTallaFN = new MST_ReferenciaProductoCatTallaFN();
        $o_MST_ReferenciaProductoCatTallaBN = $o_MST_ReferenciaProductoCatTallaFN->selectByPk( $this->getIdReferencia(), $this->getIdColor(), $this->getIdCatTalla() );
        if ( is_null( $o_MST_ReferenciaProductoCatTallaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ReferenciaProductoCatTalla ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdReferencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdReferencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdReferencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdColor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdColor";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdColor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCatTalla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCatTalla";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCatTalla()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAplicado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Aplicado";
                $s_SQLQuery2 .= $s_Separator."".$this->getAplicado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ReferenciaProductoCatTalla SET ";
            $s_Separator = "";
            if ( !is_null( $this->getAplicado() ) )
            {
                $s_SQLQuery .= $s_Separator."Aplicado = ".$this->getAplicado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdReferencia = ".$this->getIdReferencia()." AND  IdColor = ".$this->getIdColor()." AND  IdCatTalla = ".$this->getIdCatTalla().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ReferenciaProductoCatTalla WHERE  IdReferencia = ".$this->getIdReferencia()." AND  IdColor = ".$this->getIdColor()." AND  IdCatTalla = ".$this->getIdCatTalla().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>