<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Rango.xml */
/* Generado: 2021-02-01 05:17:53 */

/* Mantenimiento de los registros de la tabla MST_Rango */
abstract class BaseMST_RangoDP extends MST_RangoBV
{
    /* Constructor ( Establece los valores desde un objeto MST_RangoBN ) */
    public function __construct( MST_RangoBN $o_MST_RangoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_RangoBN ) )
        {
            $this->setByBN( $o_MST_RangoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_RangoBN */
    public function setByBN( MST_RangoBN $o_MST_RangoBN )
    {
        if ( !is_null( $o_MST_RangoBN->getIdRango() ) )
        {
            $this->setIdRango( $o_MST_RangoBN->getIdRango() );
        }
        if ( !is_null( $o_MST_RangoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_RangoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagAlquiler() ) )
        {
            $this->setFlagAlquiler( $o_MST_RangoBN->getFlagAlquiler() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagVenta() ) )
        {
            $this->setFlagVenta( $o_MST_RangoBN->getFlagVenta() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagEncofrado() ) )
        {
            $this->setFlagEncofrado( $o_MST_RangoBN->getFlagEncofrado() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagDescuentoAdelanto() ) )
        {
            $this->setFlagDescuentoAdelanto( $o_MST_RangoBN->getFlagDescuentoAdelanto() );
        }
        if ( !is_null( $o_MST_RangoBN->getFlagDescuentoContado() ) )
        {
            $this->setFlagDescuentoContado( $o_MST_RangoBN->getFlagDescuentoContado() );
        }
        if ( !is_null( $o_MST_RangoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_RangoBN->getEstado() );
        }
        if ( !is_null( $o_MST_RangoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_RangoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_RangoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_RangoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_RangoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_RangoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_RangoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_RangoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_RangoFN = new MST_RangoFN();
        $o_MST_RangoBN = $o_MST_RangoFN->selectByPk( $this->getIdRango() );
        if ( is_null( $o_MST_RangoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_Rango ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdRango() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRango";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdRango()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagAlquiler() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlagAlquiler";
                $s_SQLQuery2 .= $s_Separator."".$this->getFlagAlquiler()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlagVenta";
                $s_SQLQuery2 .= $s_Separator."".$this->getFlagVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagEncofrado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlagEncofrado";
                $s_SQLQuery2 .= $s_Separator."".$this->getFlagEncofrado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagDescuentoAdelanto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlagDescuentoAdelanto";
                $s_SQLQuery2 .= $s_Separator."".$this->getFlagDescuentoAdelanto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagDescuentoContado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlagDescuentoContado";
                $s_SQLQuery2 .= $s_Separator."".$this->getFlagDescuentoContado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_Rango SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagAlquiler() ) )
            {
                $s_SQLQuery .= $s_Separator."FlagAlquiler = ".$this->getFlagAlquiler()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."FlagVenta = ".$this->getFlagVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagEncofrado() ) )
            {
                $s_SQLQuery .= $s_Separator."FlagEncofrado = ".$this->getFlagEncofrado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagDescuentoAdelanto() ) )
            {
                $s_SQLQuery .= $s_Separator."FlagDescuentoAdelanto = ".$this->getFlagDescuentoAdelanto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagDescuentoContado() ) )
            {
                $s_SQLQuery .= $s_Separator."FlagDescuentoContado = ".$this->getFlagDescuentoContado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdRango = ".$this->getIdRango().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_Rango WHERE  IdRango = ".$this->getIdRango().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>