<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_PisosMast.xml */
/* Generado: 2020-08-18 04:21:28 */

/* Mantenimiento de los registros de la tabla MST_PisosMast */
abstract class BaseMST_PisosMastDP extends MST_PisosMastBV
{
    /* Constructor ( Establece los valores desde un objeto MST_PisosMastBN ) */
    public function __construct( MST_PisosMastBN $o_MST_PisosMastBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_PisosMastBN ) )
        {
            $this->setByBN( $o_MST_PisosMastBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_PisosMastBN */
    public function setByBN( MST_PisosMastBN $o_MST_PisosMastBN )
    {
        if ( !is_null( $o_MST_PisosMastBN->getIdPisos() ) )
        {
            $this->setIdPisos( $o_MST_PisosMastBN->getIdPisos() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_PisosMastBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_PisosMastBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_PisosMastBN->getNombre() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_PisosMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_PisosMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_PisosMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_PisosMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_PisosMastBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_PisosMastFN = new MST_PisosMastFN();
        $o_MST_PisosMastBN = $o_MST_PisosMastFN->selectByPk( $this->getIdPisos() );
        if ( is_null( $o_MST_PisosMastBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_PisosMast ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdPisos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPisos";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdPisos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_PisosMast SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdPisos = ".$this->getIdPisos().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_PisosMast WHERE  IdPisos = ".$this->getIdPisos().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>