<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemProcedencia.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Mantenimiento de los registros de la tabla MST_ItemProcedencia */
abstract class BaseMST_ItemProcedenciaDP extends MST_ItemProcedenciaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ItemProcedenciaBN ) */
    public function __construct( MST_ItemProcedenciaBN $o_MST_ItemProcedenciaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ItemProcedenciaBN ) )
        {
            $this->setByBN( $o_MST_ItemProcedenciaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ItemProcedenciaBN */
    public function setByBN( MST_ItemProcedenciaBN $o_MST_ItemProcedenciaBN )
    {
        if ( !is_null( $o_MST_ItemProcedenciaBN->getIdProcedencia() ) )
        {
            $this->setIdProcedencia( $o_MST_ItemProcedenciaBN->getIdProcedencia() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ItemProcedenciaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ItemProcedenciaBN->getEstado() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ItemProcedenciaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ItemProcedenciaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ItemProcedenciaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ItemProcedenciaBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ItemProcedenciaFN = new MST_ItemProcedenciaFN();
        $o_MST_ItemProcedenciaBN = $o_MST_ItemProcedenciaFN->selectByPk( $this->getIdProcedencia() );
        if ( is_null( $o_MST_ItemProcedenciaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ItemProcedencia ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdProcedencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProcedencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdProcedencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ItemProcedencia SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdProcedencia = '".$this->getIdProcedencia()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ItemProcedencia WHERE  IdProcedencia = '".$this->getIdProcedencia()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>