<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_DiaSemana.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Mantenimiento de los registros de la tabla MST_DiaSemana */
abstract class BaseMST_DiaSemanaDP extends MST_DiaSemanaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_DiaSemanaBN ) */
    public function __construct( MST_DiaSemanaBN $o_MST_DiaSemanaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_DiaSemanaBN ) )
        {
            $this->setByBN( $o_MST_DiaSemanaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_DiaSemanaBN */
    public function setByBN( MST_DiaSemanaBN $o_MST_DiaSemanaBN )
    {
        if ( !is_null( $o_MST_DiaSemanaBN->getIdDiaSem() ) )
        {
            $this->setIdDiaSem( $o_MST_DiaSemanaBN->getIdDiaSem() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getPrefijo() ) )
        {
            $this->setPrefijo( $o_MST_DiaSemanaBN->getPrefijo() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_DiaSemanaBN->getNombre() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getDiaNumero() ) )
        {
            $this->setDiaNumero( $o_MST_DiaSemanaBN->getDiaNumero() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getEsFeriadoFlag() ) )
        {
            $this->setEsFeriadoFlag( $o_MST_DiaSemanaBN->getEsFeriadoFlag() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_DiaSemanaFN = new MST_DiaSemanaFN();
        $o_MST_DiaSemanaBN = $o_MST_DiaSemanaFN->selectByPk( $this->getIdDiaSem() );
        if ( is_null( $o_MST_DiaSemanaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_DiaSemana ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdDiaSem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdDiaSem";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdDiaSem()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrefijo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Prefijo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPrefijo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDiaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DiaNumero";
                $s_SQLQuery2 .= $s_Separator."".$this->getDiaNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsFeriadoFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsFeriadoFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEsFeriadoFlag()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_DiaSemana SET ";
            $s_Separator = "";
            if ( !is_null( $this->getPrefijo() ) )
            {
                $s_SQLQuery .= $s_Separator."Prefijo = '".$this->getPrefijo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDiaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."DiaNumero = ".$this->getDiaNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsFeriadoFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."EsFeriadoFlag = '".$this->getEsFeriadoFlag()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdDiaSem = ".$this->getIdDiaSem().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_DiaSemana WHERE  IdDiaSem = ".$this->getIdDiaSem().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>