<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Color.xml */
/* Generado: 2024-07-06 04:27:46 */

/* Mantenimiento de los registros de la tabla MST_Color */
abstract class BaseMST_ColorDP extends MST_ColorBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ColorBN ) */
    public function __construct( MST_ColorBN $o_MST_ColorBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ColorBN ) )
        {
            $this->setByBN( $o_MST_ColorBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ColorBN */
    public function setByBN( MST_ColorBN $o_MST_ColorBN )
    {
        if ( !is_null( $o_MST_ColorBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_ColorBN->getIdColor() );
        }
        if ( !is_null( $o_MST_ColorBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_ColorBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_ColorBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_ColorBN->getCodigo() );
        }
        if ( !is_null( $o_MST_ColorBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ColorBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ColorBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ColorBN->getEstado() );
        }
        if ( !is_null( $o_MST_ColorBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ColorBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ColorBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ColorBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ColorBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ColorBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ColorBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ColorBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ColorFN = new MST_ColorFN();
        $o_MST_ColorBN = $o_MST_ColorFN->selectByPk( $this->getIdColor() );
        if ( is_null( $o_MST_ColorBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_Color ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdColor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdColor";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdColor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProveedor";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Codigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_Color SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery .= $s_Separator."IdProveedor = ".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."Codigo = '".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdColor = ".$this->getIdColor().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_Color WHERE  IdColor = ".$this->getIdColor().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>