<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClaseFamilia.xml */
/* Generado: 2021-02-01 01:16:56 */

/* Mantenimiento de los registros de la tabla MST_ClaseFamilia */
abstract class BaseMST_ClaseFamiliaDP extends MST_ClaseFamiliaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ClaseFamiliaBN ) */
    public function __construct( MST_ClaseFamiliaBN $o_MST_ClaseFamiliaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ClaseFamiliaBN ) )
        {
            $this->setByBN( $o_MST_ClaseFamiliaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ClaseFamiliaBN */
    public function setByBN( MST_ClaseFamiliaBN $o_MST_ClaseFamiliaBN )
    {
        if ( !is_null( $o_MST_ClaseFamiliaBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_MST_ClaseFamiliaBN->getIdFamilia() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_MST_ClaseFamiliaBN->getIdLinea() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ClaseFamiliaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_ClaseFamiliaBN->getCodigo() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ClaseFamiliaBN->getEstado() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ClaseFamiliaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ClaseFamiliaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ClaseFamiliaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ClaseFamiliaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ClaseFamiliaBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $o_MST_ClaseFamiliaBN = $o_MST_ClaseFamiliaFN->selectByPk( $this->getIdFamilia() );
        if ( is_null( $o_MST_ClaseFamiliaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ClaseFamilia ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdFamilia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFamilia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdFamilia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdLinea() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLinea";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdLinea()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Codigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ClaseFamilia SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdLinea() ) )
            {
                $s_SQLQuery .= $s_Separator."IdLinea = ".$this->getIdLinea()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."Codigo = '".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdFamilia = ".$this->getIdFamilia().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ClaseFamilia WHERE  IdFamilia = ".$this->getIdFamilia().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>